/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lambda.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.services.lambda.model.SubnetIdsCopier;
import software.amazon.awssdk.services.lambda.transform.VpcConfigResponseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpcConfigResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, VpcConfigResponse> {
    private final List<String> subnetIds;
    private final List<String> securityGroupIds;
    private final String vpcId;

    private VpcConfigResponse(BuilderImpl builder) {
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.vpcId = builder.vpcId;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subnetIds() == null ? 0 : this.subnetIds().hashCode());
        hashCode = 31 * hashCode + (this.securityGroupIds() == null ? 0 : this.securityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfigResponse)) {
            return false;
        }
        VpcConfigResponse other = (VpcConfigResponse)obj;
        if (other.subnetIds() == null ^ this.subnetIds() == null) {
            return false;
        }
        if (other.subnetIds() != null && !other.subnetIds().equals(this.subnetIds())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        if (other.securityGroupIds() != null && !other.securityGroupIds().equals(this.securityGroupIds())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subnetIds() != null) {
            sb.append("SubnetIds: ").append(this.subnetIds()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VpcConfigResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> subnetIds;
        private List<String> securityGroupIds;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfigResponse model) {
            this.setSubnetIds(model.subnetIds);
            this.setSecurityGroupIds(model.securityGroupIds);
            this.setVpcId(model.vpcId);
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @SafeVarargs
        public final void setSubnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @SafeVarargs
        public final void setSecurityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public VpcConfigResponse build() {
            return new VpcConfigResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpcConfigResponse> {
        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder vpcId(String var1);
    }
}

