/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetFunctionRequestModelMarshaller {
    private static final MarshallingInfo<String> FUNCTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("FunctionName").isBinary(false).build();
    private static final MarshallingInfo<String> QUALIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("Qualifier").isBinary(false).build();
    private static final GetFunctionRequestModelMarshaller INSTANCE = new GetFunctionRequestModelMarshaller();

    private GetFunctionRequestModelMarshaller() {
    }

    public static GetFunctionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetFunctionRequest getFunctionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getFunctionRequest), (String)"getFunctionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getFunctionRequest.functionName(), FUNCTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)getFunctionRequest.qualifier(), QUALIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

