/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.ColumnNamesCopier;
import software.amazon.awssdk.services.lakeformation.model.ColumnWildcard;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableWithColumnsResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableWithColumnsResource> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableWithColumnsResource.getter(TableWithColumnsResource::databaseName)).setter(TableWithColumnsResource.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TableWithColumnsResource.getter(TableWithColumnsResource::name)).setter(TableWithColumnsResource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> COLUMN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TableWithColumnsResource.getter(TableWithColumnsResource::columnNames)).setter(TableWithColumnsResource.setter(Builder::columnNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ColumnWildcard> COLUMN_WILDCARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TableWithColumnsResource.getter(TableWithColumnsResource::columnWildcard)).setter(TableWithColumnsResource.setter(Builder::columnWildcard)).constructor(ColumnWildcard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnWildcard").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, NAME_FIELD, COLUMN_NAMES_FIELD, COLUMN_WILDCARD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String name;
    private final List<String> columnNames;
    private final ColumnWildcard columnWildcard;

    private TableWithColumnsResource(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.name = builder.name;
        this.columnNames = builder.columnNames;
        this.columnWildcard = builder.columnWildcard;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String name() {
        return this.name;
    }

    public List<String> columnNames() {
        return this.columnNames;
    }

    public ColumnWildcard columnWildcard() {
        return this.columnWildcard;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnWildcard());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableWithColumnsResource)) {
            return false;
        }
        TableWithColumnsResource other = (TableWithColumnsResource)obj;
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.columnNames(), other.columnNames()) && Objects.equals(this.columnWildcard(), other.columnWildcard());
    }

    public String toString() {
        return ToString.builder((String)"TableWithColumnsResource").add("DatabaseName", (Object)this.databaseName()).add("Name", (Object)this.name()).add("ColumnNames", this.columnNames()).add("ColumnWildcard", (Object)this.columnWildcard()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ColumnNames": {
                return Optional.ofNullable(clazz.cast(this.columnNames()));
            }
            case "ColumnWildcard": {
                return Optional.ofNullable(clazz.cast(this.columnWildcard()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableWithColumnsResource, T> g) {
        return obj -> g.apply((TableWithColumnsResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseName;
        private String name;
        private List<String> columnNames = DefaultSdkAutoConstructList.getInstance();
        private ColumnWildcard columnWildcard;

        private BuilderImpl() {
        }

        private BuilderImpl(TableWithColumnsResource model) {
            this.databaseName(model.databaseName);
            this.name(model.name);
            this.columnNames(model.columnNames);
            this.columnWildcard(model.columnWildcard);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getColumnNames() {
            return this.columnNames;
        }

        @Override
        public final Builder columnNames(Collection<String> columnNames) {
            this.columnNames = ColumnNamesCopier.copy(columnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNames(String ... columnNames) {
            this.columnNames(Arrays.asList(columnNames));
            return this;
        }

        public final void setColumnNames(Collection<String> columnNames) {
            this.columnNames = ColumnNamesCopier.copy(columnNames);
        }

        public final ColumnWildcard.Builder getColumnWildcard() {
            return this.columnWildcard != null ? this.columnWildcard.toBuilder() : null;
        }

        @Override
        public final Builder columnWildcard(ColumnWildcard columnWildcard) {
            this.columnWildcard = columnWildcard;
            return this;
        }

        public final void setColumnWildcard(ColumnWildcard.BuilderImpl columnWildcard) {
            this.columnWildcard = columnWildcard != null ? columnWildcard.build() : null;
        }

        public TableWithColumnsResource build() {
            return new TableWithColumnsResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableWithColumnsResource> {
        public Builder databaseName(String var1);

        public Builder name(String var1);

        public Builder columnNames(Collection<String> var1);

        public Builder columnNames(String ... var1);

        public Builder columnWildcard(ColumnWildcard var1);

        default public Builder columnWildcard(Consumer<ColumnWildcard.Builder> columnWildcard) {
            return this.columnWildcard((ColumnWildcard)((ColumnWildcard.Builder)ColumnWildcard.builder().applyMutation(columnWildcard)).build());
        }
    }
}

