/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ComparisonOperator {
    EQ("EQ"),
    NE("NE"),
    LE("LE"),
    LT("LT"),
    GE("GE"),
    GT("GT"),
    CONTAINS("CONTAINS"),
    NOT_CONTAINS("NOT_CONTAINS"),
    BEGINS_WITH("BEGINS_WITH"),
    IN("IN"),
    BETWEEN("BETWEEN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ComparisonOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComparisonOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ComparisonOperator.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComparisonOperator> knownValues() {
        return Stream.of(ComparisonOperator.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

