/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TransactionStatus {
    ACTIVE("ACTIVE"),
    COMMITTED("COMMITTED"),
    ABORTED("ABORTED"),
    COMMIT_IN_PROGRESS("COMMIT_IN_PROGRESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TransactionStatus> VALUE_MAP;
    private final String value;

    private TransactionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransactionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TransactionStatus> knownValues() {
        EnumSet<TransactionStatus> knownValues = EnumSet.allOf(TransactionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TransactionStatus.class, TransactionStatus::toString);
    }
}

