/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataCellsFilterResponse extends LakeFormationResponse implements
        ToCopyableBuilder<ListDataCellsFilterResponse.Builder, ListDataCellsFilterResponse> {
    private static final SdkField<List<DataCellsFilter>> DATA_CELLS_FILTERS_FIELD = SdkField
            .<List<DataCellsFilter>> builder(MarshallingType.LIST)
            .memberName("DataCellsFilters")
            .getter(getter(ListDataCellsFilterResponse::dataCellsFilters))
            .setter(setter(Builder::dataCellsFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCellsFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataCellsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataCellsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDataCellsFilterResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_CELLS_FILTERS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DataCellsFilter> dataCellsFilters;

    private final String nextToken;

    private ListDataCellsFilterResponse(BuilderImpl builder) {
        super(builder);
        this.dataCellsFilters = builder.dataCellsFilters;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataCellsFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataCellsFilters() {
        return dataCellsFilters != null && !(dataCellsFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataCellFilter</code> structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataCellsFilters} method.
     * </p>
     * 
     * @return A list of <code>DataCellFilter</code> structures.
     */
    public final List<DataCellsFilter> dataCellsFilters() {
        return dataCellsFilters;
    }

    /**
     * <p>
     * A continuation token, if not all requested data cell filters have been returned.
     * </p>
     * 
     * @return A continuation token, if not all requested data cell filters have been returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDataCellsFilters() ? dataCellsFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataCellsFilterResponse)) {
            return false;
        }
        ListDataCellsFilterResponse other = (ListDataCellsFilterResponse) obj;
        return hasDataCellsFilters() == other.hasDataCellsFilters()
                && Objects.equals(dataCellsFilters(), other.dataCellsFilters()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataCellsFilterResponse")
                .add("DataCellsFilters", hasDataCellsFilters() ? dataCellsFilters() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataCellsFilters":
            return Optional.ofNullable(clazz.cast(dataCellsFilters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataCellsFilters", DATA_CELLS_FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataCellsFilterResponse, T> g) {
        return obj -> g.apply((ListDataCellsFilterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LakeFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDataCellsFilterResponse> {
        /**
         * <p>
         * A list of <code>DataCellFilter</code> structures.
         * </p>
         * 
         * @param dataCellsFilters
         *        A list of <code>DataCellFilter</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCellsFilters(Collection<DataCellsFilter> dataCellsFilters);

        /**
         * <p>
         * A list of <code>DataCellFilter</code> structures.
         * </p>
         * 
         * @param dataCellsFilters
         *        A list of <code>DataCellFilter</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCellsFilters(DataCellsFilter... dataCellsFilters);

        /**
         * <p>
         * A list of <code>DataCellFilter</code> structures.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lakeformation.model.DataCellsFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.lakeformation.model.DataCellsFilter#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lakeformation.model.DataCellsFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #dataCellsFilters(List<DataCellsFilter>)}.
         * 
         * @param dataCellsFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lakeformation.model.DataCellsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCellsFilters(java.util.Collection<DataCellsFilter>)
         */
        Builder dataCellsFilters(Consumer<DataCellsFilter.Builder>... dataCellsFilters);

        /**
         * <p>
         * A continuation token, if not all requested data cell filters have been returned.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if not all requested data cell filters have been returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private List<DataCellsFilter> dataCellsFilters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataCellsFilterResponse model) {
            super(model);
            dataCellsFilters(model.dataCellsFilters);
            nextToken(model.nextToken);
        }

        public final List<DataCellsFilter.Builder> getDataCellsFilters() {
            List<DataCellsFilter.Builder> result = DataCellsFilterListCopier.copyToBuilder(this.dataCellsFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataCellsFilters(Collection<DataCellsFilter.BuilderImpl> dataCellsFilters) {
            this.dataCellsFilters = DataCellsFilterListCopier.copyFromBuilder(dataCellsFilters);
        }

        @Override
        public final Builder dataCellsFilters(Collection<DataCellsFilter> dataCellsFilters) {
            this.dataCellsFilters = DataCellsFilterListCopier.copy(dataCellsFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataCellsFilters(DataCellsFilter... dataCellsFilters) {
            dataCellsFilters(Arrays.asList(dataCellsFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataCellsFilters(Consumer<DataCellsFilter.Builder>... dataCellsFilters) {
            dataCellsFilters(Stream.of(dataCellsFilters).map(c -> DataCellsFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataCellsFilterResponse build() {
            return new ListDataCellsFilterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
