/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.ExpressionCopier;
import software.amazon.awssdk.services.lakeformation.model.LFTag;
import software.amazon.awssdk.services.lakeformation.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LFTagPolicyResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LFTagPolicyResource> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(LFTagPolicyResource.getter(LFTagPolicyResource::catalogId)).setter(LFTagPolicyResource.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(LFTagPolicyResource.getter(LFTagPolicyResource::resourceTypeAsString)).setter(LFTagPolicyResource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<List<LFTag>> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Expression").getter(LFTagPolicyResource.getter(LFTagPolicyResource::expression)).setter(LFTagPolicyResource.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LFTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXPRESSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpressionName").getter(LFTagPolicyResource.getter(LFTagPolicyResource::expressionName)).setter(LFTagPolicyResource.setter(Builder::expressionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, RESOURCE_TYPE_FIELD, EXPRESSION_FIELD, EXPRESSION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LFTagPolicyResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String catalogId;
    private final String resourceType;
    private final List<LFTag> expression;
    private final String expressionName;

    private LFTagPolicyResource(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.resourceType = builder.resourceType;
        this.expression = builder.expression;
        this.expressionName = builder.expressionName;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasExpression() {
        return this.expression != null && !(this.expression instanceof SdkAutoConstructList);
    }

    public final List<LFTag> expression() {
        return this.expression;
    }

    public final String expressionName() {
        return this.expressionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpression() ? this.expression() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LFTagPolicyResource)) {
            return false;
        }
        LFTagPolicyResource other = (LFTagPolicyResource)obj;
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasExpression() == other.hasExpression() && Objects.equals(this.expression(), other.expression()) && Objects.equals(this.expressionName(), other.expressionName());
    }

    public final String toString() {
        return ToString.builder((String)"LFTagPolicyResource").add("CatalogId", (Object)this.catalogId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Expression", this.hasExpression() ? this.expression() : null).add("ExpressionName", (Object)this.expressionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "ExpressionName": {
                return Optional.ofNullable(clazz.cast(this.expressionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("Expression", EXPRESSION_FIELD);
        map.put("ExpressionName", EXPRESSION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LFTagPolicyResource, T> g) {
        return obj -> g.apply((LFTagPolicyResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogId;
        private String resourceType;
        private List<LFTag> expression = DefaultSdkAutoConstructList.getInstance();
        private String expressionName;

        private BuilderImpl() {
        }

        private BuilderImpl(LFTagPolicyResource model) {
            this.catalogId(model.catalogId);
            this.resourceType(model.resourceType);
            this.expression(model.expression);
            this.expressionName(model.expressionName);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<LFTag.Builder> getExpression() {
            List<LFTag.Builder> result = ExpressionCopier.copyToBuilder(this.expression);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpression(Collection<LFTag.BuilderImpl> expression) {
            this.expression = ExpressionCopier.copyFromBuilder(expression);
        }

        @Override
        public final Builder expression(Collection<LFTag> expression) {
            this.expression = ExpressionCopier.copy(expression);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expression(LFTag ... expression) {
            this.expression(Arrays.asList(expression));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expression(Consumer<LFTag.Builder> ... expression) {
            this.expression(Stream.of(expression).map(c -> (LFTag)((LFTag.Builder)LFTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExpressionName() {
            return this.expressionName;
        }

        public final void setExpressionName(String expressionName) {
            this.expressionName = expressionName;
        }

        @Override
        public final Builder expressionName(String expressionName) {
            this.expressionName = expressionName;
            return this;
        }

        public LFTagPolicyResource build() {
            return new LFTagPolicyResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LFTagPolicyResource> {
        public Builder catalogId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder expression(Collection<LFTag> var1);

        public Builder expression(LFTag ... var1);

        public Builder expression(Consumer<LFTag.Builder> ... var1);

        public Builder expressionName(String var1);
    }
}

