/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.TaggedTable;

public class SearchTablesByLFTagsIterable
implements SdkIterable<SearchTablesByLfTagsResponse> {
    private final LakeFormationClient client;
    private final SearchTablesByLfTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchTablesByLFTagsIterable(LakeFormationClient client, SearchTablesByLfTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchTablesByLfTagsResponseFetcher();
    }

    public Iterator<SearchTablesByLfTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TaggedTable> tableList() {
        Function<SearchTablesByLfTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableList() != null) {
                return response.tableList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchTablesByLfTagsResponseFetcher
    implements SyncPageFetcher<SearchTablesByLfTagsResponse> {
        private SearchTablesByLfTagsResponseFetcher() {
        }

        public boolean hasNextPage(SearchTablesByLfTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchTablesByLfTagsResponse nextPage(SearchTablesByLfTagsResponse previousPage) {
            if (previousPage == null) {
                return SearchTablesByLFTagsIterable.this.client.searchTablesByLFTags(SearchTablesByLFTagsIterable.this.firstRequest);
            }
            return SearchTablesByLFTagsIterable.this.client.searchTablesByLFTags((SearchTablesByLfTagsRequest)((Object)SearchTablesByLFTagsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

