/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.internal;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.ClientEndpointProvider;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lakeformation.LakeFormationServiceClientConfiguration;
import software.amazon.awssdk.services.lakeformation.auth.scheme.LakeFormationAuthSchemeProvider;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LakeFormationServiceClientConfigurationBuilder
implements LakeFormationServiceClientConfiguration.Builder {
    private final SdkClientConfiguration.Builder config;

    public LakeFormationServiceClientConfigurationBuilder() {
        this(SdkClientConfiguration.builder());
    }

    public LakeFormationServiceClientConfigurationBuilder(SdkClientConfiguration.Builder config) {
        this.config = config;
    }

    @Override
    public LakeFormationServiceClientConfiguration.Builder overrideConfiguration(ClientOverrideConfiguration overrideConfiguration) {
        this.config.putAll(overrideConfiguration);
        return this;
    }

    @Override
    public ClientOverrideConfiguration overrideConfiguration() {
        return (ClientOverrideConfiguration)this.config.asOverrideConfigurationBuilder().build();
    }

    @Override
    public LakeFormationServiceClientConfiguration.Builder endpointOverride(URI endpointOverride) {
        if (endpointOverride != null) {
            this.config.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER, (Object)ClientEndpointProvider.forEndpointOverride((URI)endpointOverride));
        } else {
            this.config.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER, null);
        }
        return this;
    }

    @Override
    public URI endpointOverride() {
        ClientEndpointProvider clientEndpoint = (ClientEndpointProvider)this.config.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER);
        if (clientEndpoint != null && clientEndpoint.isEndpointOverridden()) {
            return clientEndpoint.clientEndpoint();
        }
        return null;
    }

    @Override
    public LakeFormationServiceClientConfiguration.Builder endpointProvider(EndpointProvider endpointProvider) {
        this.config.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    @Override
    public EndpointProvider endpointProvider() {
        return (EndpointProvider)this.config.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
    }

    @Override
    public LakeFormationServiceClientConfiguration.Builder region(Region region) {
        this.config.option((ClientOption)AwsClientOption.AWS_REGION, (Object)region);
        return this;
    }

    @Override
    public Region region() {
        return (Region)this.config.option((ClientOption)AwsClientOption.AWS_REGION);
    }

    @Override
    public LakeFormationServiceClientConfiguration.Builder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider) {
        this.config.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER, credentialsProvider);
        return this;
    }

    @Override
    public IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider() {
        return (IdentityProvider)this.config.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER);
    }

    @Override
    public LakeFormationServiceClientConfiguration.Builder putAuthScheme(AuthScheme<?> authScheme) {
        ((Map)this.config.computeOptionIfAbsent((ClientOption)SdkClientOption.AUTH_SCHEMES, HashMap::new)).put(authScheme.schemeId(), authScheme);
        return this;
    }

    @Override
    public Map<String, AuthScheme<?>> authSchemes() {
        Map authSchemes = (Map)this.config.option((ClientOption)SdkClientOption.AUTH_SCHEMES);
        return Collections.unmodifiableMap(authSchemes == null ? Collections.emptyMap() : authSchemes);
    }

    @Override
    public LakeFormationServiceClientConfiguration.Builder authSchemeProvider(LakeFormationAuthSchemeProvider authSchemeProvider) {
        this.config.option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER, (Object)authSchemeProvider);
        return this;
    }

    @Override
    public LakeFormationAuthSchemeProvider authSchemeProvider() {
        AuthSchemeProvider result = (AuthSchemeProvider)this.config.option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER);
        if (result == null) {
            return null;
        }
        return (LakeFormationAuthSchemeProvider)Validate.isInstanceOf(LakeFormationAuthSchemeProvider.class, (Object)result, (String)("Expected an instance of " + LakeFormationAuthSchemeProvider.class.getSimpleName()), (Object[])new Object[0]);
    }

    @Override
    public LakeFormationServiceClientConfiguration build() {
        return new LakeFormationServiceClientConfiguration(this);
    }
}

