/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.AsyncResponseTransformerUtils;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.LakeFormationServiceClientConfiguration;
import software.amazon.awssdk.services.lakeformation.internal.LakeFormationServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.lakeformation.model.AccessDeniedException;
import software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.AlreadyExistsException;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlResponse;
import software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.CancelTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.CancelTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.CommitTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.CommitTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.ConcurrentModificationException;
import software.amazon.awssdk.services.lakeformation.model.CreateDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationOptInRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationOptInResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationOptInRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationOptInResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelResponse;
import software.amazon.awssdk.services.lakeformation.model.DeregisterResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.DeregisterResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.EntityNotFoundException;
import software.amazon.awssdk.services.lakeformation.model.ExpiredException;
import software.amazon.awssdk.services.lakeformation.model.ExtendTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.ExtendTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakePrincipalRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakePrincipalResponse;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStateRequest;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStateResponse;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsResponse;
import software.amazon.awssdk.services.lakeformation.model.GlueEncryptionException;
import software.amazon.awssdk.services.lakeformation.model.GrantPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.GrantPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.InternalServiceException;
import software.amazon.awssdk.services.lakeformation.model.InvalidInputException;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationException;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.ListLakeFormationOptInsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLakeFormationOptInsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagExpressionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagExpressionsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse;
import software.amazon.awssdk.services.lakeformation.model.OperationTimeoutException;
import software.amazon.awssdk.services.lakeformation.model.PermissionTypeMismatchException;
import software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsRequest;
import software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsResponse;
import software.amazon.awssdk.services.lakeformation.model.RegisterResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.RegisterResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.ResourceNotReadyException;
import software.amazon.awssdk.services.lakeformation.model.ResourceNumberLimitExceededException;
import software.amazon.awssdk.services.lakeformation.model.RevokePermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.RevokePermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningRequest;
import software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningResponse;
import software.amazon.awssdk.services.lakeformation.model.StartTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.StartTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.StatisticsNotReadyYetException;
import software.amazon.awssdk.services.lakeformation.model.ThrottledException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCanceledException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCommitInProgressException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCommittedException;
import software.amazon.awssdk.services.lakeformation.model.UpdateDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerResponse;
import software.amazon.awssdk.services.lakeformation.model.WorkUnitsNotReadyYetException;
import software.amazon.awssdk.services.lakeformation.transform.AddLfTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.AssumeDecoratedRoleWithSamlRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.BatchGrantPermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.BatchRevokePermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CancelTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CommitTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateLakeFormationIdentityCenterConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateLakeFormationOptInRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateLfTagExpressionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteLakeFormationIdentityCenterConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteLakeFormationOptInRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteLfTagExpressionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteObjectsOnCancelRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeregisterResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DescribeLakeFormationIdentityCenterConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DescribeResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DescribeTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ExtendTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetDataLakePrincipalRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetDataLakeSettingsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetEffectivePermissionsForPathRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetLfTagExpressionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetQueryStateRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetQueryStatisticsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetResourceLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetTableObjectsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetTemporaryGluePartitionCredentialsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetTemporaryGlueTableCredentialsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetWorkUnitResultsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetWorkUnitsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GrantPermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListLakeFormationOptInsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListLfTagExpressionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListPermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListResourcesRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListTableStorageOptimizersRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListTransactionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.PutDataLakeSettingsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.RegisterResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.RemoveLfTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.RevokePermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.SearchDatabasesByLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.SearchTablesByLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.StartQueryPlanningRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.StartTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateLakeFormationIdentityCenterConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateLfTagExpressionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateTableObjectsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateTableStorageOptimizerRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
final class DefaultLakeFormationAsyncClient
implements LakeFormationAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultLakeFormationAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLakeFormationAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AddLfTagsToResourceResponse> addLFTagsToResource(AddLfTagsToResourceRequest addLfTagsToResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addLfTagsToResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, addLfTagsToResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddLFTagsToResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddLfTagsToResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddLFTagsToResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddLfTagsToResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addLfTagsToResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$addLFTagsToResource$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$addLFTagsToResource$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AssumeDecoratedRoleWithSamlResponse> assumeDecoratedRoleWithSAML(AssumeDecoratedRoleWithSamlRequest assumeDecoratedRoleWithSamlRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)assumeDecoratedRoleWithSamlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, assumeDecoratedRoleWithSamlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssumeDecoratedRoleWithSAML");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssumeDecoratedRoleWithSamlResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeDecoratedRoleWithSAML").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssumeDecoratedRoleWithSamlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)assumeDecoratedRoleWithSamlRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$assumeDecoratedRoleWithSAML$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$assumeDecoratedRoleWithSAML$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGrantPermissionsResponse> batchGrantPermissions(BatchGrantPermissionsRequest batchGrantPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGrantPermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, batchGrantPermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGrantPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGrantPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGrantPermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchGrantPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGrantPermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$batchGrantPermissions$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$batchGrantPermissions$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchRevokePermissionsResponse> batchRevokePermissions(BatchRevokePermissionsRequest batchRevokePermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchRevokePermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, batchRevokePermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchRevokePermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchRevokePermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchRevokePermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchRevokePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchRevokePermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$batchRevokePermissions$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$batchRevokePermissions$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CancelTransactionResponse> cancelTransaction(CancelTransactionRequest cancelTransactionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, cancelTransactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelTransaction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelTransactionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelTransaction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelTransactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelTransactionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$cancelTransaction$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$cancelTransaction$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CommitTransactionResponse> commitTransaction(CommitTransactionRequest commitTransactionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)commitTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, commitTransactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CommitTransaction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CommitTransactionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CommitTransaction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CommitTransactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)commitTransactionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$commitTransaction$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$commitTransaction$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDataCellsFilterResponse> createDataCellsFilter(CreateDataCellsFilterRequest createDataCellsFilterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDataCellsFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, createDataCellsFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataCellsFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataCellsFilterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataCellsFilter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDataCellsFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDataCellsFilterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$createDataCellsFilter$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$createDataCellsFilter$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLfTagResponse> createLFTag(CreateLfTagRequest createLfTagRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLfTagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, createLfTagRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLFTag");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLfTagResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLFTag").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLfTagRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLfTagRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$createLFTag$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$createLFTag$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLfTagExpressionResponse> createLFTagExpression(CreateLfTagExpressionRequest createLfTagExpressionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLfTagExpressionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, createLfTagExpressionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLFTagExpression");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLfTagExpressionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLFTagExpression").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLfTagExpressionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLfTagExpressionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$createLFTagExpression$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$createLFTagExpression$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLakeFormationIdentityCenterConfigurationResponse> createLakeFormationIdentityCenterConfiguration(CreateLakeFormationIdentityCenterConfigurationRequest createLakeFormationIdentityCenterConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLakeFormationIdentityCenterConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, createLakeFormationIdentityCenterConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLakeFormationIdentityCenterConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLakeFormationIdentityCenterConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLakeFormationIdentityCenterConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLakeFormationIdentityCenterConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLakeFormationIdentityCenterConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$createLakeFormationIdentityCenterConfiguration$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$createLakeFormationIdentityCenterConfiguration$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLakeFormationOptInResponse> createLakeFormationOptIn(CreateLakeFormationOptInRequest createLakeFormationOptInRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLakeFormationOptInRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, createLakeFormationOptInRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLakeFormationOptIn");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLakeFormationOptInResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLakeFormationOptIn").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLakeFormationOptInRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLakeFormationOptInRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$createLakeFormationOptIn$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$createLakeFormationOptIn$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDataCellsFilterResponse> deleteDataCellsFilter(DeleteDataCellsFilterRequest deleteDataCellsFilterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDataCellsFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDataCellsFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataCellsFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataCellsFilterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataCellsFilter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDataCellsFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDataCellsFilterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$deleteDataCellsFilter$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$deleteDataCellsFilter$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLfTagResponse> deleteLFTag(DeleteLfTagRequest deleteLfTagRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLfTagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLfTagRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLFTag");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLfTagResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLFTag").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLfTagRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLfTagRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$deleteLFTag$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$deleteLFTag$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLfTagExpressionResponse> deleteLFTagExpression(DeleteLfTagExpressionRequest deleteLfTagExpressionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLfTagExpressionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLfTagExpressionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLFTagExpression");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLfTagExpressionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLFTagExpression").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLfTagExpressionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLfTagExpressionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$deleteLFTagExpression$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$deleteLFTagExpression$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLakeFormationIdentityCenterConfigurationResponse> deleteLakeFormationIdentityCenterConfiguration(DeleteLakeFormationIdentityCenterConfigurationRequest deleteLakeFormationIdentityCenterConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLakeFormationIdentityCenterConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLakeFormationIdentityCenterConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLakeFormationIdentityCenterConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLakeFormationIdentityCenterConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLakeFormationIdentityCenterConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLakeFormationIdentityCenterConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLakeFormationIdentityCenterConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$deleteLakeFormationIdentityCenterConfiguration$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$deleteLakeFormationIdentityCenterConfiguration$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLakeFormationOptInResponse> deleteLakeFormationOptIn(DeleteLakeFormationOptInRequest deleteLakeFormationOptInRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLakeFormationOptInRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLakeFormationOptInRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLakeFormationOptIn");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLakeFormationOptInResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLakeFormationOptIn").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLakeFormationOptInRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLakeFormationOptInRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$deleteLakeFormationOptIn$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$deleteLakeFormationOptIn$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteObjectsOnCancelResponse> deleteObjectsOnCancel(DeleteObjectsOnCancelRequest deleteObjectsOnCancelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteObjectsOnCancelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, deleteObjectsOnCancelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteObjectsOnCancel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteObjectsOnCancelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObjectsOnCancel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteObjectsOnCancelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteObjectsOnCancelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$deleteObjectsOnCancel$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$deleteObjectsOnCancel$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterResourceResponse> deregisterResource(DeregisterResourceRequest deregisterResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, deregisterResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeregisterResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deregisterResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$deregisterResource$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$deregisterResource$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLakeFormationIdentityCenterConfigurationResponse> describeLakeFormationIdentityCenterConfiguration(DescribeLakeFormationIdentityCenterConfigurationRequest describeLakeFormationIdentityCenterConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLakeFormationIdentityCenterConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, describeLakeFormationIdentityCenterConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLakeFormationIdentityCenterConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLakeFormationIdentityCenterConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLakeFormationIdentityCenterConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeLakeFormationIdentityCenterConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeLakeFormationIdentityCenterConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$describeLakeFormationIdentityCenterConfiguration$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$describeLakeFormationIdentityCenterConfiguration$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeResourceResponse> describeResource(DescribeResourceRequest describeResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, describeResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$describeResource$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$describeResource$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTransactionResponse> describeTransaction(DescribeTransactionRequest describeTransactionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, describeTransactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTransaction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTransactionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTransaction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTransactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTransactionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$describeTransaction$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$describeTransaction$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExtendTransactionResponse> extendTransaction(ExtendTransactionRequest extendTransactionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)extendTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, extendTransactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExtendTransaction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExtendTransactionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExtendTransaction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ExtendTransactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)extendTransactionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$extendTransaction$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$extendTransaction$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDataCellsFilterResponse> getDataCellsFilter(GetDataCellsFilterRequest getDataCellsFilterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDataCellsFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getDataCellsFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataCellsFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataCellsFilterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataCellsFilter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDataCellsFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDataCellsFilterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$getDataCellsFilter$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$getDataCellsFilter$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDataLakePrincipalResponse> getDataLakePrincipal(GetDataLakePrincipalRequest getDataLakePrincipalRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDataLakePrincipalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getDataLakePrincipalRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataLakePrincipal");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataLakePrincipalResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataLakePrincipal").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDataLakePrincipalRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDataLakePrincipalRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$getDataLakePrincipal$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$getDataLakePrincipal$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDataLakeSettingsResponse> getDataLakeSettings(GetDataLakeSettingsRequest getDataLakeSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDataLakeSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getDataLakeSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataLakeSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataLakeSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataLakeSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDataLakeSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDataLakeSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$getDataLakeSettings$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$getDataLakeSettings$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetEffectivePermissionsForPathResponse> getEffectivePermissionsForPath(GetEffectivePermissionsForPathRequest getEffectivePermissionsForPathRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEffectivePermissionsForPathRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getEffectivePermissionsForPathRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEffectivePermissionsForPath");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEffectivePermissionsForPathResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEffectivePermissionsForPath").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetEffectivePermissionsForPathRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getEffectivePermissionsForPathRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$getEffectivePermissionsForPath$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$getEffectivePermissionsForPath$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLfTagResponse> getLFTag(GetLfTagRequest getLfTagRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLfTagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getLfTagRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLFTag");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLfTagResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLFTag").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLfTagRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLfTagRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$getLFTag$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$getLFTag$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLfTagExpressionResponse> getLFTagExpression(GetLfTagExpressionRequest getLfTagExpressionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLfTagExpressionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getLfTagExpressionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLFTagExpression");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLfTagExpressionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLFTagExpression").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetLfTagExpressionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLfTagExpressionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$getLFTagExpression$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$getLFTagExpression$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetQueryStateResponse> getQueryState(GetQueryStateRequest getQueryStateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getQueryStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getQueryStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryStateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetQueryStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getQueryStateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$getQueryState$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$getQueryState$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetQueryStatisticsResponse> getQueryStatistics(GetQueryStatisticsRequest getQueryStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getQueryStatisticsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getQueryStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryStatisticsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryStatistics").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetQueryStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getQueryStatisticsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$getQueryStatistics$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$getQueryStatistics$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourceLfTagsResponse> getResourceLFTags(GetResourceLfTagsRequest getResourceLfTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourceLfTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getResourceLfTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceLFTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceLfTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceLFTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetResourceLfTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResourceLfTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$getResourceLFTags$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$getResourceLFTags$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTableObjectsResponse> getTableObjects(GetTableObjectsRequest getTableObjectsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTableObjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getTableObjectsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTableObjects");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTableObjectsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTableObjects").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetTableObjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTableObjectsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$getTableObjects$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$getTableObjects$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTemporaryGluePartitionCredentialsResponse> getTemporaryGluePartitionCredentials(GetTemporaryGluePartitionCredentialsRequest getTemporaryGluePartitionCredentialsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTemporaryGluePartitionCredentialsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getTemporaryGluePartitionCredentialsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTemporaryGluePartitionCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTemporaryGluePartitionCredentialsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemporaryGluePartitionCredentials").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetTemporaryGluePartitionCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTemporaryGluePartitionCredentialsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$getTemporaryGluePartitionCredentials$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$getTemporaryGluePartitionCredentials$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTemporaryGlueTableCredentialsResponse> getTemporaryGlueTableCredentials(GetTemporaryGlueTableCredentialsRequest getTemporaryGlueTableCredentialsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTemporaryGlueTableCredentialsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getTemporaryGlueTableCredentialsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTemporaryGlueTableCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTemporaryGlueTableCredentialsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemporaryGlueTableCredentials").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetTemporaryGlueTableCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTemporaryGlueTableCredentialsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$getTemporaryGlueTableCredentials$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$getTemporaryGlueTableCredentials$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public <ReturnT> CompletableFuture<ReturnT> getWorkUnitResults(GetWorkUnitResultsRequest getWorkUnitResultsRequest, AsyncResponseTransformer<GetWorkUnitResultsResponse, ReturnT> asyncResponseTransformer) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getWorkUnitResultsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getWorkUnitResultsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkUnitResults");
            Pair pair = AsyncResponseTransformerUtils.wrapWithEndOfStreamFuture(asyncResponseTransformer);
            asyncResponseTransformer = (AsyncResponseTransformer)pair.left();
            CompletableFuture endOfStreamFuture = (CompletableFuture)pair.right();
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkUnitResultsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "data-";
            String resolvedHostExpression = "data-";
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkUnitResults").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetWorkUnitResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withAsyncResponseTransformer(asyncResponseTransformer).withInput((SdkRequest)getWorkUnitResultsRequest), asyncResponseTransformer);
            AsyncResponseTransformer finalAsyncResponseTransformer = asyncResponseTransformer;
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$getWorkUnitResults$140(finalAsyncResponseTransformer, endOfStreamFuture, metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            AsyncResponseTransformer finalAsyncResponseTransformer = asyncResponseTransformer;
            FunctionalUtils.runAndLogError((Logger)log, (String)"Exception thrown in exceptionOccurred callback, ignoring", () -> finalAsyncResponseTransformer.exceptionOccurred(t));
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$getWorkUnitResults$142((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetWorkUnitsResponse> getWorkUnits(GetWorkUnitsRequest getWorkUnitsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getWorkUnitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getWorkUnitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkUnits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkUnitsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkUnits").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetWorkUnitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getWorkUnitsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$getWorkUnits$145(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$getWorkUnits$146((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GrantPermissionsResponse> grantPermissions(GrantPermissionsRequest grantPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)grantPermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, grantPermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GrantPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GrantPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GrantPermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GrantPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)grantPermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$grantPermissions$149(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$grantPermissions$150((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDataCellsFilterResponse> listDataCellsFilter(ListDataCellsFilterRequest listDataCellsFilterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDataCellsFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listDataCellsFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDataCellsFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataCellsFilterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataCellsFilter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDataCellsFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDataCellsFilterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$listDataCellsFilter$153(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$listDataCellsFilter$154((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLfTagExpressionsResponse> listLFTagExpressions(ListLfTagExpressionsRequest listLfTagExpressionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLfTagExpressionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listLfTagExpressionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLFTagExpressions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLfTagExpressionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLFTagExpressions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLfTagExpressionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLfTagExpressionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$listLFTagExpressions$157(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$listLFTagExpressions$158((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLfTagsResponse> listLFTags(ListLfTagsRequest listLfTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLfTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listLfTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLFTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLfTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLFTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLfTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLfTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$listLFTags$161(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$listLFTags$162((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLakeFormationOptInsResponse> listLakeFormationOptIns(ListLakeFormationOptInsRequest listLakeFormationOptInsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLakeFormationOptInsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listLakeFormationOptInsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLakeFormationOptIns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLakeFormationOptInsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLakeFormationOptIns").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLakeFormationOptInsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLakeFormationOptInsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$listLakeFormationOptIns$165(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$listLakeFormationOptIns$166((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPermissionsResponse> listPermissions(ListPermissionsRequest listPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listPermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$listPermissions$169(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$listPermissions$170((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListResourcesResponse> listResources(ListResourcesRequest listResourcesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listResourcesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$listResources$173(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$listResources$174((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTableStorageOptimizersResponse> listTableStorageOptimizers(ListTableStorageOptimizersRequest listTableStorageOptimizersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTableStorageOptimizersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listTableStorageOptimizersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTableStorageOptimizers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTableStorageOptimizersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTableStorageOptimizers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTableStorageOptimizersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTableStorageOptimizersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$listTableStorageOptimizers$177(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$listTableStorageOptimizers$178((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTransactionsResponse> listTransactions(ListTransactionsRequest listTransactionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTransactionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listTransactionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTransactions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTransactionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTransactions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTransactionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTransactionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$listTransactions$181(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$listTransactions$182((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutDataLakeSettingsResponse> putDataLakeSettings(PutDataLakeSettingsRequest putDataLakeSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putDataLakeSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, putDataLakeSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDataLakeSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDataLakeSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDataLakeSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutDataLakeSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putDataLakeSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$putDataLakeSettings$185(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$putDataLakeSettings$186((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterResourceResponse> registerResource(RegisterResourceRequest registerResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, registerResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$registerResource$189(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$registerResource$190((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveLfTagsFromResourceResponse> removeLFTagsFromResource(RemoveLfTagsFromResourceRequest removeLfTagsFromResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeLfTagsFromResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, removeLfTagsFromResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveLFTagsFromResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveLfTagsFromResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveLFTagsFromResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveLfTagsFromResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeLfTagsFromResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$removeLFTagsFromResource$193(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$removeLFTagsFromResource$194((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RevokePermissionsResponse> revokePermissions(RevokePermissionsRequest revokePermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)revokePermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, revokePermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokePermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokePermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokePermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RevokePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)revokePermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$revokePermissions$197(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$revokePermissions$198((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SearchDatabasesByLfTagsResponse> searchDatabasesByLFTags(SearchDatabasesByLfTagsRequest searchDatabasesByLfTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchDatabasesByLfTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, searchDatabasesByLfTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchDatabasesByLFTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchDatabasesByLfTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchDatabasesByLFTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SearchDatabasesByLfTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)searchDatabasesByLfTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$searchDatabasesByLFTags$201(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$searchDatabasesByLFTags$202((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SearchTablesByLfTagsResponse> searchTablesByLFTags(SearchTablesByLfTagsRequest searchTablesByLfTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchTablesByLfTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, searchTablesByLfTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchTablesByLFTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchTablesByLfTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchTablesByLFTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SearchTablesByLfTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)searchTablesByLfTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$searchTablesByLFTags$205(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$searchTablesByLFTags$206((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartQueryPlanningResponse> startQueryPlanning(StartQueryPlanningRequest startQueryPlanningRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startQueryPlanningRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, startQueryPlanningRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartQueryPlanning");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartQueryPlanningResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartQueryPlanning").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartQueryPlanningRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)startQueryPlanningRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$startQueryPlanning$209(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$startQueryPlanning$210((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartTransactionResponse> startTransaction(StartTransactionRequest startTransactionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, startTransactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTransaction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTransactionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTransaction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartTransactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startTransactionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$startTransaction$213(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$startTransaction$214((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDataCellsFilterResponse> updateDataCellsFilter(UpdateDataCellsFilterRequest updateDataCellsFilterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDataCellsFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, updateDataCellsFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataCellsFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataCellsFilterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataCellsFilter").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateDataCellsFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDataCellsFilterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$updateDataCellsFilter$217(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$updateDataCellsFilter$218((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateLfTagResponse> updateLFTag(UpdateLfTagRequest updateLfTagRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLfTagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, updateLfTagRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLFTag");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLfTagResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLFTag").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateLfTagRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateLfTagRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$updateLFTag$221(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$updateLFTag$222((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateLfTagExpressionResponse> updateLFTagExpression(UpdateLfTagExpressionRequest updateLfTagExpressionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLfTagExpressionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, updateLfTagExpressionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLFTagExpression");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLfTagExpressionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLFTagExpression").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateLfTagExpressionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateLfTagExpressionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$updateLFTagExpression$225(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$updateLFTagExpression$226((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateLakeFormationIdentityCenterConfigurationResponse> updateLakeFormationIdentityCenterConfiguration(UpdateLakeFormationIdentityCenterConfigurationRequest updateLakeFormationIdentityCenterConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLakeFormationIdentityCenterConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, updateLakeFormationIdentityCenterConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLakeFormationIdentityCenterConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLakeFormationIdentityCenterConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLakeFormationIdentityCenterConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateLakeFormationIdentityCenterConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateLakeFormationIdentityCenterConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$updateLakeFormationIdentityCenterConfiguration$229(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$updateLakeFormationIdentityCenterConfiguration$230((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateResourceResponse> updateResource(UpdateResourceRequest updateResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, updateResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$updateResource$233(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$updateResource$234((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTableObjectsResponse> updateTableObjects(UpdateTableObjectsRequest updateTableObjectsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTableObjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, updateTableObjectsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTableObjects");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableObjectsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTableObjects").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateTableObjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateTableObjectsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$updateTableObjects$237(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$updateTableObjects$238((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTableStorageOptimizerResponse> updateTableStorageOptimizer(UpdateTableStorageOptimizerRequest updateTableStorageOptimizerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTableStorageOptimizerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, updateTableStorageOptimizerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTableStorageOptimizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableStorageOptimizerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTableStorageOptimizer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateTableStorageOptimizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateTableStorageOptimizerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLakeFormationAsyncClient.lambda$updateTableStorageOptimizer$241(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationAsyncClient.lambda$updateTableStorageOptimizer$242((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final LakeFormationServiceClientConfiguration serviceClientConfiguration() {
        return new LakeFormationServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "lakeformation";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(LakeFormationException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        LakeFormationServiceClientConfigurationBuilder serviceConfigBuilder = new LakeFormationServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateTableStorageOptimizer$242(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTableStorageOptimizer$241(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTableStorageOptimizerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateTableObjects$238(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTableObjects$237(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTableObjectsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateResource$234(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateResource$233(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateLakeFormationIdentityCenterConfiguration$230(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLakeFormationIdentityCenterConfiguration$229(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateLakeFormationIdentityCenterConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateLFTagExpression$226(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLFTagExpression$225(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateLfTagExpressionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateLFTag$222(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLFTag$221(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateLfTagResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDataCellsFilter$218(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDataCellsFilter$217(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDataCellsFilterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startTransaction$214(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTransaction$213(List metricPublishers, MetricCollector apiCallMetricCollector, StartTransactionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startQueryPlanning$210(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startQueryPlanning$209(List metricPublishers, MetricCollector apiCallMetricCollector, StartQueryPlanningResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$searchTablesByLFTags$206(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchTablesByLFTags$205(List metricPublishers, MetricCollector apiCallMetricCollector, SearchTablesByLfTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$searchDatabasesByLFTags$202(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchDatabasesByLFTags$201(List metricPublishers, MetricCollector apiCallMetricCollector, SearchDatabasesByLfTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$revokePermissions$198(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokePermissions$197(List metricPublishers, MetricCollector apiCallMetricCollector, RevokePermissionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeLFTagsFromResource$194(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeLFTagsFromResource$193(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveLfTagsFromResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerResource$190(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerResource$189(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putDataLakeSettings$186(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putDataLakeSettings$185(List metricPublishers, MetricCollector apiCallMetricCollector, PutDataLakeSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTransactions$182(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTransactions$181(List metricPublishers, MetricCollector apiCallMetricCollector, ListTransactionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTableStorageOptimizers$178(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTableStorageOptimizers$177(List metricPublishers, MetricCollector apiCallMetricCollector, ListTableStorageOptimizersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listResources$174(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResources$173(List metricPublishers, MetricCollector apiCallMetricCollector, ListResourcesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPermissions$170(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPermissions$169(List metricPublishers, MetricCollector apiCallMetricCollector, ListPermissionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLakeFormationOptIns$166(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLakeFormationOptIns$165(List metricPublishers, MetricCollector apiCallMetricCollector, ListLakeFormationOptInsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLFTags$162(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLFTags$161(List metricPublishers, MetricCollector apiCallMetricCollector, ListLfTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLFTagExpressions$158(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLFTagExpressions$157(List metricPublishers, MetricCollector apiCallMetricCollector, ListLfTagExpressionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDataCellsFilter$154(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDataCellsFilter$153(List metricPublishers, MetricCollector apiCallMetricCollector, ListDataCellsFilterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$grantPermissions$150(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$grantPermissions$149(List metricPublishers, MetricCollector apiCallMetricCollector, GrantPermissionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getWorkUnits$146(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkUnits$145(List metricPublishers, MetricCollector apiCallMetricCollector, GetWorkUnitsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getWorkUnitResults$142(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkUnitResults$140(AsyncResponseTransformer finalAsyncResponseTransformer, CompletableFuture endOfStreamFuture, List metricPublishers, MetricCollector apiCallMetricCollector, Object r, Throwable e) {
        if (e != null) {
            FunctionalUtils.runAndLogError((Logger)log, (String)"Exception thrown in exceptionOccurred callback, ignoring", () -> finalAsyncResponseTransformer.exceptionOccurred(e));
        }
        endOfStreamFuture.whenComplete((r2, e2) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
    }

    private static /* synthetic */ void lambda$getTemporaryGlueTableCredentials$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTemporaryGlueTableCredentials$134(List metricPublishers, MetricCollector apiCallMetricCollector, GetTemporaryGlueTableCredentialsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTemporaryGluePartitionCredentials$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTemporaryGluePartitionCredentials$130(List metricPublishers, MetricCollector apiCallMetricCollector, GetTemporaryGluePartitionCredentialsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTableObjects$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTableObjects$126(List metricPublishers, MetricCollector apiCallMetricCollector, GetTableObjectsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getResourceLFTags$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceLFTags$122(List metricPublishers, MetricCollector apiCallMetricCollector, GetResourceLfTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getQueryStatistics$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getQueryStatistics$118(List metricPublishers, MetricCollector apiCallMetricCollector, GetQueryStatisticsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getQueryState$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getQueryState$114(List metricPublishers, MetricCollector apiCallMetricCollector, GetQueryStateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLFTagExpression$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLFTagExpression$110(List metricPublishers, MetricCollector apiCallMetricCollector, GetLfTagExpressionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLFTag$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLFTag$106(List metricPublishers, MetricCollector apiCallMetricCollector, GetLfTagResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getEffectivePermissionsForPath$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEffectivePermissionsForPath$102(List metricPublishers, MetricCollector apiCallMetricCollector, GetEffectivePermissionsForPathResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDataLakeSettings$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataLakeSettings$98(List metricPublishers, MetricCollector apiCallMetricCollector, GetDataLakeSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDataLakePrincipal$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataLakePrincipal$94(List metricPublishers, MetricCollector apiCallMetricCollector, GetDataLakePrincipalResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDataCellsFilter$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataCellsFilter$90(List metricPublishers, MetricCollector apiCallMetricCollector, GetDataCellsFilterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$extendTransaction$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$extendTransaction$86(List metricPublishers, MetricCollector apiCallMetricCollector, ExtendTransactionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTransaction$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTransaction$82(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTransactionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeResource$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeResource$78(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeLakeFormationIdentityCenterConfiguration$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLakeFormationIdentityCenterConfiguration$74(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeLakeFormationIdentityCenterConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deregisterResource$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterResource$70(List metricPublishers, MetricCollector apiCallMetricCollector, DeregisterResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteObjectsOnCancel$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteObjectsOnCancel$66(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteObjectsOnCancelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLakeFormationOptIn$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLakeFormationOptIn$62(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLakeFormationOptInResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLakeFormationIdentityCenterConfiguration$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLakeFormationIdentityCenterConfiguration$58(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLakeFormationIdentityCenterConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLFTagExpression$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLFTagExpression$54(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLfTagExpressionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLFTag$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLFTag$50(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLfTagResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDataCellsFilter$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataCellsFilter$46(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDataCellsFilterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLakeFormationOptIn$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLakeFormationOptIn$42(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLakeFormationOptInResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLakeFormationIdentityCenterConfiguration$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLakeFormationIdentityCenterConfiguration$38(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLakeFormationIdentityCenterConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLFTagExpression$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLFTagExpression$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLfTagExpressionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLFTag$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLFTag$30(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLfTagResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDataCellsFilter$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataCellsFilter$26(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDataCellsFilterResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$commitTransaction$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$commitTransaction$22(List metricPublishers, MetricCollector apiCallMetricCollector, CommitTransactionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$cancelTransaction$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelTransaction$18(List metricPublishers, MetricCollector apiCallMetricCollector, CancelTransactionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchRevokePermissions$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchRevokePermissions$14(List metricPublishers, MetricCollector apiCallMetricCollector, BatchRevokePermissionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchGrantPermissions$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGrantPermissions$10(List metricPublishers, MetricCollector apiCallMetricCollector, BatchGrantPermissionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$assumeDecoratedRoleWithSAML$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$assumeDecoratedRoleWithSAML$6(List metricPublishers, MetricCollector apiCallMetricCollector, AssumeDecoratedRoleWithSamlResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addLFTagsToResource$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addLFTagsToResource$2(List metricPublishers, MetricCollector apiCallMetricCollector, AddLfTagsToResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

