/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.LFTagPair;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse;

public class ListLFTagsPublisher
implements SdkPublisher<ListLfTagsResponse> {
    private final LakeFormationAsyncClient client;
    private final ListLfTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLFTagsPublisher(LakeFormationAsyncClient client, ListLfTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLFTagsPublisher(LakeFormationAsyncClient client, ListLfTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLfTagsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLfTagsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LFTagPair> lfTags() {
        Function<ListLfTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.lfTags() != null) {
                return response.lfTags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLfTagsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLfTagsResponseFetcher
    implements AsyncPageFetcher<ListLfTagsResponse> {
        private ListLfTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListLfTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLfTagsResponse> nextPage(ListLfTagsResponse previousPage) {
            if (previousPage == null) {
                return ListLFTagsPublisher.this.client.listLFTags(ListLFTagsPublisher.this.firstRequest);
            }
            return ListLFTagsPublisher.this.client.listLFTags((ListLfTagsRequest)((Object)ListLFTagsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

