/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QueryStateString {
    PENDING("PENDING"),
    WORKUNITS_AVAILABLE("WORKUNITS_AVAILABLE"),
    ERROR("ERROR"),
    FINISHED("FINISHED"),
    EXPIRED("EXPIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QueryStateString> VALUE_MAP;
    private final String value;

    private QueryStateString(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QueryStateString fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QueryStateString> knownValues() {
        EnumSet<QueryStateString> knownValues = EnumSet.allOf(QueryStateString.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QueryStateString.class, QueryStateString::toString);
    }
}

