/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.LFTagPair;
import software.amazon.awssdk.services.lakeformation.model.LFTagsListCopier;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLfTagsResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, ListLfTagsResponse> {
    private static final SdkField<List<LFTagPair>> LF_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LFTags").getter(ListLfTagsResponse.getter(ListLfTagsResponse::lfTags)).setter(ListLfTagsResponse.setter(Builder::lfTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LFTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LFTagPair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLfTagsResponse.getter(ListLfTagsResponse::nextToken)).setter(ListLfTagsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LF_TAGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LFTags", LF_TAGS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<LFTagPair> lfTags;
    private final String nextToken;

    private ListLfTagsResponse(BuilderImpl builder) {
        super(builder);
        this.lfTags = builder.lfTags;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLfTags() {
        return this.lfTags != null && !(this.lfTags instanceof SdkAutoConstructList);
    }

    public final List<LFTagPair> lfTags() {
        return this.lfTags;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLfTags() ? this.lfTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLfTagsResponse)) {
            return false;
        }
        ListLfTagsResponse other = (ListLfTagsResponse)((Object)obj);
        return this.hasLfTags() == other.hasLfTags() && Objects.equals(this.lfTags(), other.lfTags()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLfTagsResponse").add("LFTags", this.hasLfTags() ? this.lfTags() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LFTags": {
                return Optional.ofNullable(clazz.cast(this.lfTags()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListLfTagsResponse, T> g) {
        return obj -> g.apply((ListLfTagsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private List<LFTagPair> lfTags = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLfTagsResponse model) {
            super(model);
            this.lfTags(model.lfTags);
            this.nextToken(model.nextToken);
        }

        public final List<LFTagPair.Builder> getLfTags() {
            List<LFTagPair.Builder> result = LFTagsListCopier.copyToBuilder(this.lfTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLfTags(Collection<LFTagPair.BuilderImpl> lfTags) {
            this.lfTags = LFTagsListCopier.copyFromBuilder(lfTags);
        }

        @Override
        public final Builder lfTags(Collection<LFTagPair> lfTags) {
            this.lfTags = LFTagsListCopier.copy(lfTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lfTags(LFTagPair ... lfTags) {
            this.lfTags(Arrays.asList(lfTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lfTags(Consumer<LFTagPair.Builder> ... lfTags) {
            this.lfTags(Stream.of(lfTags).map(c -> (LFTagPair)((LFTagPair.Builder)LFTagPair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLfTagsResponse build() {
            return new ListLfTagsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLfTagsResponse> {
        public Builder lfTags(Collection<LFTagPair> var1);

        public Builder lfTags(LFTagPair ... var1);

        public Builder lfTags(Consumer<LFTagPair.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

