/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.EnableStatus;
import software.amazon.awssdk.services.lakeformation.model.ScopeTargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalFilteringConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalFilteringConfiguration> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ExternalFilteringConfiguration.getter(ExternalFilteringConfiguration::statusAsString)).setter(ExternalFilteringConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> AUTHORIZED_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedTargets").getter(ExternalFilteringConfiguration.getter(ExternalFilteringConfiguration::authorizedTargets)).setter(ExternalFilteringConfiguration.setter(Builder::authorizedTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, AUTHORIZED_TARGETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Status", STATUS_FIELD);
            this.put("AuthorizedTargets", AUTHORIZED_TARGETS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final List<String> authorizedTargets;

    private ExternalFilteringConfiguration(BuilderImpl builder) {
        this.status = builder.status;
        this.authorizedTargets = builder.authorizedTargets;
    }

    public final EnableStatus status() {
        return EnableStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasAuthorizedTargets() {
        return this.authorizedTargets != null && !(this.authorizedTargets instanceof SdkAutoConstructList);
    }

    public final List<String> authorizedTargets() {
        return this.authorizedTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedTargets() ? this.authorizedTargets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalFilteringConfiguration)) {
            return false;
        }
        ExternalFilteringConfiguration other = (ExternalFilteringConfiguration)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasAuthorizedTargets() == other.hasAuthorizedTargets() && Objects.equals(this.authorizedTargets(), other.authorizedTargets());
    }

    public final String toString() {
        return ToString.builder((String)"ExternalFilteringConfiguration").add("Status", (Object)this.statusAsString()).add("AuthorizedTargets", this.hasAuthorizedTargets() ? this.authorizedTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AuthorizedTargets": {
                return Optional.ofNullable(clazz.cast(this.authorizedTargets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExternalFilteringConfiguration, T> g) {
        return obj -> g.apply((ExternalFilteringConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private List<String> authorizedTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalFilteringConfiguration model) {
            this.status(model.status);
            this.authorizedTargets(model.authorizedTargets);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnableStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getAuthorizedTargets() {
            if (this.authorizedTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorizedTargets;
        }

        public final void setAuthorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = ScopeTargetsCopier.copy(authorizedTargets);
        }

        @Override
        public final Builder authorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = ScopeTargetsCopier.copy(authorizedTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTargets(String ... authorizedTargets) {
            this.authorizedTargets(Arrays.asList(authorizedTargets));
            return this;
        }

        public ExternalFilteringConfiguration build() {
            return new ExternalFilteringConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalFilteringConfiguration> {
        public Builder status(String var1);

        public Builder status(EnableStatus var1);

        public Builder authorizedTargets(Collection<String> var1);

        public Builder authorizedTargets(String ... var1);
    }
}

