/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterResourceRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, RegisterResourceRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(RegisterResourceRequest.getter(RegisterResourceRequest::resourceArn)).setter(RegisterResourceRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Boolean> USE_SERVICE_LINKED_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseServiceLinkedRole").getter(RegisterResourceRequest.getter(RegisterResourceRequest::useServiceLinkedRole)).setter(RegisterResourceRequest.setter(Builder::useServiceLinkedRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseServiceLinkedRole").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(RegisterResourceRequest.getter(RegisterResourceRequest::roleArn)).setter(RegisterResourceRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Boolean> WITH_FEDERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WithFederation").getter(RegisterResourceRequest.getter(RegisterResourceRequest::withFederation)).setter(RegisterResourceRequest.setter(Builder::withFederation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithFederation").build()}).build();
    private static final SdkField<Boolean> HYBRID_ACCESS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HybridAccessEnabled").getter(RegisterResourceRequest.getter(RegisterResourceRequest::hybridAccessEnabled)).setter(RegisterResourceRequest.setter(Builder::hybridAccessEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HybridAccessEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, USE_SERVICE_LINKED_ROLE_FIELD, ROLE_ARN_FIELD, WITH_FEDERATION_FIELD, HYBRID_ACCESS_ENABLED_FIELD));
    private final String resourceArn;
    private final Boolean useServiceLinkedRole;
    private final String roleArn;
    private final Boolean withFederation;
    private final Boolean hybridAccessEnabled;

    private RegisterResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.useServiceLinkedRole = builder.useServiceLinkedRole;
        this.roleArn = builder.roleArn;
        this.withFederation = builder.withFederation;
        this.hybridAccessEnabled = builder.hybridAccessEnabled;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Boolean useServiceLinkedRole() {
        return this.useServiceLinkedRole;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Boolean withFederation() {
        return this.withFederation;
    }

    public final Boolean hybridAccessEnabled() {
        return this.hybridAccessEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.useServiceLinkedRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.withFederation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hybridAccessEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterResourceRequest)) {
            return false;
        }
        RegisterResourceRequest other = (RegisterResourceRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.useServiceLinkedRole(), other.useServiceLinkedRole()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.withFederation(), other.withFederation()) && Objects.equals(this.hybridAccessEnabled(), other.hybridAccessEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterResourceRequest").add("ResourceArn", (Object)this.resourceArn()).add("UseServiceLinkedRole", (Object)this.useServiceLinkedRole()).add("RoleArn", (Object)this.roleArn()).add("WithFederation", (Object)this.withFederation()).add("HybridAccessEnabled", (Object)this.hybridAccessEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "UseServiceLinkedRole": {
                return Optional.ofNullable(clazz.cast(this.useServiceLinkedRole()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "WithFederation": {
                return Optional.ofNullable(clazz.cast(this.withFederation()));
            }
            case "HybridAccessEnabled": {
                return Optional.ofNullable(clazz.cast(this.hybridAccessEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterResourceRequest, T> g) {
        return obj -> g.apply((RegisterResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private Boolean useServiceLinkedRole;
        private String roleArn;
        private Boolean withFederation;
        private Boolean hybridAccessEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterResourceRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.useServiceLinkedRole(model.useServiceLinkedRole);
            this.roleArn(model.roleArn);
            this.withFederation(model.withFederation);
            this.hybridAccessEnabled(model.hybridAccessEnabled);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Boolean getUseServiceLinkedRole() {
            return this.useServiceLinkedRole;
        }

        public final void setUseServiceLinkedRole(Boolean useServiceLinkedRole) {
            this.useServiceLinkedRole = useServiceLinkedRole;
        }

        @Override
        public final Builder useServiceLinkedRole(Boolean useServiceLinkedRole) {
            this.useServiceLinkedRole = useServiceLinkedRole;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Boolean getWithFederation() {
            return this.withFederation;
        }

        public final void setWithFederation(Boolean withFederation) {
            this.withFederation = withFederation;
        }

        @Override
        public final Builder withFederation(Boolean withFederation) {
            this.withFederation = withFederation;
            return this;
        }

        public final Boolean getHybridAccessEnabled() {
            return this.hybridAccessEnabled;
        }

        public final void setHybridAccessEnabled(Boolean hybridAccessEnabled) {
            this.hybridAccessEnabled = hybridAccessEnabled;
        }

        @Override
        public final Builder hybridAccessEnabled(Boolean hybridAccessEnabled) {
            this.hybridAccessEnabled = hybridAccessEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterResourceRequest build() {
            return new RegisterResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterResourceRequest> {
        public Builder resourceArn(String var1);

        public Builder useServiceLinkedRole(Boolean var1);

        public Builder roleArn(String var1);

        public Builder withFederation(Boolean var1);

        public Builder hybridAccessEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

