/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lakeformation.DefaultLakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.DefaultLakeFormationBaseClientBuilder;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClientBuilder;
import software.amazon.awssdk.services.lakeformation.LakeFormationServiceClientConfiguration;
import software.amazon.awssdk.services.lakeformation.endpoints.LakeFormationEndpointProvider;

@SdkInternalApi
final class DefaultLakeFormationAsyncClientBuilder
extends DefaultLakeFormationBaseClientBuilder<LakeFormationAsyncClientBuilder, LakeFormationAsyncClient>
implements LakeFormationAsyncClientBuilder {
    DefaultLakeFormationAsyncClientBuilder() {
    }

    @Override
    public DefaultLakeFormationAsyncClientBuilder endpointProvider(LakeFormationEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LakeFormationAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultLakeFormationAsyncClientBuilder.validateClientOptions(clientConfiguration);
        LakeFormationServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultLakeFormationAsyncClient client = new DefaultLakeFormationAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private LakeFormationServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return LakeFormationServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

