/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.services.lakeformation.model.TagValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLfTagResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, GetLfTagResponse> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(GetLfTagResponse.getter(GetLfTagResponse::catalogId)).setter(GetLfTagResponse.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> TAG_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagKey").getter(GetLfTagResponse.getter(GetLfTagResponse::tagKey)).setter(GetLfTagResponse.setter(Builder::tagKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()}).build();
    private static final SdkField<List<String>> TAG_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagValues").getter(GetLfTagResponse.getter(GetLfTagResponse::tagValues)).setter(GetLfTagResponse.setter(Builder::tagValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, TAG_KEY_FIELD, TAG_VALUES_FIELD));
    private final String catalogId;
    private final String tagKey;
    private final List<String> tagValues;

    private GetLfTagResponse(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.tagKey = builder.tagKey;
        this.tagValues = builder.tagValues;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String tagKey() {
        return this.tagKey;
    }

    public final boolean hasTagValues() {
        return this.tagValues != null && !(this.tagValues instanceof SdkAutoConstructList);
    }

    public final List<String> tagValues() {
        return this.tagValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagValues() ? this.tagValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLfTagResponse)) {
            return false;
        }
        GetLfTagResponse other = (GetLfTagResponse)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.tagKey(), other.tagKey()) && this.hasTagValues() == other.hasTagValues() && Objects.equals(this.tagValues(), other.tagValues());
    }

    public final String toString() {
        return ToString.builder((String)"GetLfTagResponse").add("CatalogId", (Object)this.catalogId()).add("TagKey", (Object)this.tagKey()).add("TagValues", this.hasTagValues() ? this.tagValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "TagKey": {
                return Optional.ofNullable(clazz.cast(this.tagKey()));
            }
            case "TagValues": {
                return Optional.ofNullable(clazz.cast(this.tagValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLfTagResponse, T> g) {
        return obj -> g.apply((GetLfTagResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private String catalogId;
        private String tagKey;
        private List<String> tagValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLfTagResponse model) {
            super(model);
            this.catalogId(model.catalogId);
            this.tagKey(model.tagKey);
            this.tagValues(model.tagValues);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getTagKey() {
            return this.tagKey;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final Collection<String> getTagValues() {
            if (this.tagValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagValues;
        }

        public final void setTagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
        }

        @Override
        public final Builder tagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(String ... tagValues) {
            this.tagValues(Arrays.asList(tagValues));
            return this;
        }

        @Override
        public GetLfTagResponse build() {
            return new GetLfTagResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLfTagResponse> {
        public Builder catalogId(String var1);

        public Builder tagKey(String var1);

        public Builder tagValues(Collection<String> var1);

        public Builder tagValues(String ... var1);
    }
}

