/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing the additional details to be returned in the <code>AdditionalDetails</code> attribute of
 * <code>PrincipalResourcePermissions</code>.
 * </p>
 * <p>
 * If a catalog resource is shared through Resource Access Manager (RAM), then there will exist a corresponding RAM
 * resource share ARN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetailsMap implements SdkPojo, Serializable, ToCopyableBuilder<DetailsMap.Builder, DetailsMap> {
    private static final SdkField<List<String>> RESOURCE_SHARE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceShare")
            .getter(getter(DetailsMap::resourceShare))
            .setter(setter(Builder::resourceShare))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceShare").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> resourceShare;

    private DetailsMap(BuilderImpl builder) {
        this.resourceShare = builder.resourceShare;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceShare property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceShare() {
        return resourceShare != null && !(resourceShare instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A resource share ARN for a catalog resource shared through RAM.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceShare} method.
     * </p>
     * 
     * @return A resource share ARN for a catalog resource shared through RAM.
     */
    public final List<String> resourceShare() {
        return resourceShare;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceShare() ? resourceShare() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetailsMap)) {
            return false;
        }
        DetailsMap other = (DetailsMap) obj;
        return hasResourceShare() == other.hasResourceShare() && Objects.equals(resourceShare(), other.resourceShare());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetailsMap").add("ResourceShare", hasResourceShare() ? resourceShare() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceShare":
            return Optional.ofNullable(clazz.cast(resourceShare()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetailsMap, T> g) {
        return obj -> g.apply((DetailsMap) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetailsMap> {
        /**
         * <p>
         * A resource share ARN for a catalog resource shared through RAM.
         * </p>
         * 
         * @param resourceShare
         *        A resource share ARN for a catalog resource shared through RAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShare(Collection<String> resourceShare);

        /**
         * <p>
         * A resource share ARN for a catalog resource shared through RAM.
         * </p>
         * 
         * @param resourceShare
         *        A resource share ARN for a catalog resource shared through RAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShare(String... resourceShare);
    }

    static final class BuilderImpl implements Builder {
        private List<String> resourceShare = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetailsMap model) {
            resourceShare(model.resourceShare);
        }

        public final Collection<String> getResourceShare() {
            if (resourceShare instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceShare;
        }

        public final void setResourceShare(Collection<String> resourceShare) {
            this.resourceShare = ResourceShareListCopier.copy(resourceShare);
        }

        @Override
        public final Builder resourceShare(Collection<String> resourceShare) {
            this.resourceShare = ResourceShareListCopier.copy(resourceShare);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShare(String... resourceShare) {
            resourceShare(Arrays.asList(resourceShare));
            return this;
        }

        @Override
        public DetailsMap build() {
            return new DetailsMap(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
