/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.LakeFormationServiceClientConfiguration;
import software.amazon.awssdk.services.lakeformation.model.AccessDeniedException;
import software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.AlreadyExistsException;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlResponse;
import software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.CancelTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.CancelTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.CommitTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.CommitTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.ConcurrentModificationException;
import software.amazon.awssdk.services.lakeformation.model.CreateDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelResponse;
import software.amazon.awssdk.services.lakeformation.model.DeregisterResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.DeregisterResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.EntityNotFoundException;
import software.amazon.awssdk.services.lakeformation.model.ExpiredException;
import software.amazon.awssdk.services.lakeformation.model.ExtendTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.ExtendTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStateRequest;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStateResponse;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsResponse;
import software.amazon.awssdk.services.lakeformation.model.GlueEncryptionException;
import software.amazon.awssdk.services.lakeformation.model.GrantPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.GrantPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.InternalServiceException;
import software.amazon.awssdk.services.lakeformation.model.InvalidInputException;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationException;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse;
import software.amazon.awssdk.services.lakeformation.model.OperationTimeoutException;
import software.amazon.awssdk.services.lakeformation.model.PermissionTypeMismatchException;
import software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsRequest;
import software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsResponse;
import software.amazon.awssdk.services.lakeformation.model.RegisterResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.RegisterResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.ResourceNotReadyException;
import software.amazon.awssdk.services.lakeformation.model.ResourceNumberLimitExceededException;
import software.amazon.awssdk.services.lakeformation.model.RevokePermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.RevokePermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningRequest;
import software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningResponse;
import software.amazon.awssdk.services.lakeformation.model.StartTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.StartTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.StatisticsNotReadyYetException;
import software.amazon.awssdk.services.lakeformation.model.ThrottledException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCanceledException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCommitInProgressException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCommittedException;
import software.amazon.awssdk.services.lakeformation.model.UpdateDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerResponse;
import software.amazon.awssdk.services.lakeformation.model.WorkUnitsNotReadyYetException;
import software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable;
import software.amazon.awssdk.services.lakeformation.paginators.GetTableObjectsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.GetWorkUnitsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListDataCellsFilterIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListLFTagsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListTableStorageOptimizersIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListTransactionsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.SearchDatabasesByLFTagsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.SearchTablesByLFTagsIterable;
import software.amazon.awssdk.services.lakeformation.transform.AddLfTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.AssumeDecoratedRoleWithSamlRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.BatchGrantPermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.BatchRevokePermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CancelTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CommitTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteObjectsOnCancelRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeregisterResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DescribeResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DescribeTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ExtendTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetDataLakeSettingsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetEffectivePermissionsForPathRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetQueryStateRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetQueryStatisticsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetResourceLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetTableObjectsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetTemporaryGluePartitionCredentialsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetTemporaryGlueTableCredentialsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetWorkUnitResultsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetWorkUnitsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GrantPermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListPermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListResourcesRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListTableStorageOptimizersRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListTransactionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.PutDataLakeSettingsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.RegisterResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.RemoveLfTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.RevokePermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.SearchDatabasesByLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.SearchTablesByLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.StartQueryPlanningRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.StartTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateTableObjectsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateTableStorageOptimizerRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultLakeFormationClient
implements LakeFormationClient {
    private static final Logger log = Logger.loggerFor(DefaultLakeFormationClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final LakeFormationServiceClientConfiguration serviceClientConfiguration;

    protected DefaultLakeFormationClient(LakeFormationServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddLfTagsToResourceResponse addLFTagsToResource(AddLfTagsToResourceRequest addLfTagsToResourceRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddLfTagsToResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, addLfTagsToResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddLFTagsToResource");
            AddLfTagsToResourceResponse addLfTagsToResourceResponse = (AddLfTagsToResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddLFTagsToResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addLfTagsToResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddLfTagsToResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addLfTagsToResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$addLFTagsToResource$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssumeDecoratedRoleWithSamlResponse assumeDecoratedRoleWithSAML(AssumeDecoratedRoleWithSamlRequest assumeDecoratedRoleWithSamlRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssumeDecoratedRoleWithSamlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, assumeDecoratedRoleWithSamlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssumeDecoratedRoleWithSAML");
            AssumeDecoratedRoleWithSamlResponse assumeDecoratedRoleWithSamlResponse = (AssumeDecoratedRoleWithSamlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeDecoratedRoleWithSAML").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)assumeDecoratedRoleWithSamlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssumeDecoratedRoleWithSamlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return assumeDecoratedRoleWithSamlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$assumeDecoratedRoleWithSAML$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGrantPermissionsResponse batchGrantPermissions(BatchGrantPermissionsRequest batchGrantPermissionsRequest) throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGrantPermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, batchGrantPermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGrantPermissions");
            BatchGrantPermissionsResponse batchGrantPermissionsResponse = (BatchGrantPermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGrantPermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGrantPermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGrantPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGrantPermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$batchGrantPermissions$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchRevokePermissionsResponse batchRevokePermissions(BatchRevokePermissionsRequest batchRevokePermissionsRequest) throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchRevokePermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, batchRevokePermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchRevokePermissions");
            BatchRevokePermissionsResponse batchRevokePermissionsResponse = (BatchRevokePermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchRevokePermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchRevokePermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchRevokePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchRevokePermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$batchRevokePermissions$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelTransactionResponse cancelTransaction(CancelTransactionRequest cancelTransactionRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, TransactionCommittedException, TransactionCommitInProgressException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelTransactionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, cancelTransactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelTransaction");
            CancelTransactionResponse cancelTransactionResponse = (CancelTransactionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelTransaction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelTransactionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelTransactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelTransactionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$cancelTransaction$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommitTransactionResponse commitTransaction(CommitTransactionRequest commitTransactionRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, TransactionCanceledException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CommitTransactionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, commitTransactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CommitTransaction");
            CommitTransactionResponse commitTransactionResponse = (CommitTransactionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CommitTransaction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)commitTransactionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CommitTransactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return commitTransactionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$commitTransaction$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDataCellsFilterResponse createDataCellsFilter(CreateDataCellsFilterRequest createDataCellsFilterRequest) throws AlreadyExistsException, InvalidInputException, EntityNotFoundException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataCellsFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, createDataCellsFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataCellsFilter");
            CreateDataCellsFilterResponse createDataCellsFilterResponse = (CreateDataCellsFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataCellsFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDataCellsFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDataCellsFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDataCellsFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$createDataCellsFilter$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLfTagResponse createLFTag(CreateLfTagRequest createLfTagRequest) throws EntityNotFoundException, InvalidInputException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLfTagResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, createLfTagRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLFTag");
            CreateLfTagResponse createLfTagResponse = (CreateLfTagResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLFTag").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLfTagRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLfTagRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLfTagResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$createLFTag$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDataCellsFilterResponse deleteDataCellsFilter(DeleteDataCellsFilterRequest deleteDataCellsFilterRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataCellsFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, deleteDataCellsFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataCellsFilter");
            DeleteDataCellsFilterResponse deleteDataCellsFilterResponse = (DeleteDataCellsFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataCellsFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDataCellsFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDataCellsFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDataCellsFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$deleteDataCellsFilter$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLfTagResponse deleteLFTag(DeleteLfTagRequest deleteLfTagRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLfTagResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, deleteLfTagRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLFTag");
            DeleteLfTagResponse deleteLfTagResponse = (DeleteLfTagResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLFTag").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLfTagRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLfTagRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLfTagResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$deleteLFTag$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteObjectsOnCancelResponse deleteObjectsOnCancel(DeleteObjectsOnCancelRequest deleteObjectsOnCancelRequest) throws InternalServiceException, InvalidInputException, OperationTimeoutException, EntityNotFoundException, TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteObjectsOnCancelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, deleteObjectsOnCancelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteObjectsOnCancel");
            DeleteObjectsOnCancelResponse deleteObjectsOnCancelResponse = (DeleteObjectsOnCancelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObjectsOnCancel").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteObjectsOnCancelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteObjectsOnCancelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteObjectsOnCancelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$deleteObjectsOnCancel$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterResourceResponse deregisterResource(DeregisterResourceRequest deregisterResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, deregisterResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterResource");
            DeregisterResourceResponse deregisterResourceResponse = (DeregisterResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$deregisterResource$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeResourceResponse describeResource(DescribeResourceRequest describeResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, describeResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResource");
            DescribeResourceResponse describeResourceResponse = (DescribeResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$describeResource$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTransactionResponse describeTransaction(DescribeTransactionRequest describeTransactionRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTransactionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, describeTransactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTransaction");
            DescribeTransactionResponse describeTransactionResponse = (DescribeTransactionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTransaction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTransactionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTransactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTransactionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$describeTransaction$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendTransactionResponse extendTransaction(ExtendTransactionRequest extendTransactionRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, TransactionCommittedException, TransactionCanceledException, TransactionCommitInProgressException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExtendTransactionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, extendTransactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExtendTransaction");
            ExtendTransactionResponse extendTransactionResponse = (ExtendTransactionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExtendTransaction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)extendTransactionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExtendTransactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return extendTransactionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$extendTransaction$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataCellsFilterResponse getDataCellsFilter(GetDataCellsFilterRequest getDataCellsFilterRequest) throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataCellsFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, getDataCellsFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataCellsFilter");
            GetDataCellsFilterResponse getDataCellsFilterResponse = (GetDataCellsFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataCellsFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDataCellsFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDataCellsFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDataCellsFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$getDataCellsFilter$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataLakeSettingsResponse getDataLakeSettings(GetDataLakeSettingsRequest getDataLakeSettingsRequest) throws InternalServiceException, InvalidInputException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataLakeSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, getDataLakeSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataLakeSettings");
            GetDataLakeSettingsResponse getDataLakeSettingsResponse = (GetDataLakeSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataLakeSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDataLakeSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDataLakeSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDataLakeSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$getDataLakeSettings$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEffectivePermissionsForPathResponse getEffectivePermissionsForPath(GetEffectivePermissionsForPathRequest getEffectivePermissionsForPathRequest) throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEffectivePermissionsForPathResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, getEffectivePermissionsForPathRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEffectivePermissionsForPath");
            GetEffectivePermissionsForPathResponse getEffectivePermissionsForPathResponse = (GetEffectivePermissionsForPathResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEffectivePermissionsForPath").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEffectivePermissionsForPathRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEffectivePermissionsForPathRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEffectivePermissionsForPathResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$getEffectivePermissionsForPath$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetEffectivePermissionsForPathIterable getEffectivePermissionsForPathPaginator(GetEffectivePermissionsForPathRequest getEffectivePermissionsForPathRequest) throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        return new GetEffectivePermissionsForPathIterable(this, this.applyPaginatorUserAgent(getEffectivePermissionsForPathRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLfTagResponse getLFTag(GetLfTagRequest getLfTagRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLfTagResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, getLfTagRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLFTag");
            GetLfTagResponse getLfTagResponse = (GetLfTagResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLFTag").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLfTagRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLfTagRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLfTagResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$getLFTag$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryStateResponse getQueryState(GetQueryStateRequest getQueryStateRequest) throws InternalServiceException, InvalidInputException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, getQueryStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryState");
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            GetQueryStateResponse getQueryStateResponse = (GetQueryStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryState").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getQueryStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetQueryStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getQueryStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$getQueryState$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryStatisticsResponse getQueryStatistics(GetQueryStatisticsRequest getQueryStatisticsRequest) throws StatisticsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryStatisticsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, getQueryStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryStatistics");
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            GetQueryStatisticsResponse getQueryStatisticsResponse = (GetQueryStatisticsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryStatistics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getQueryStatisticsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetQueryStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getQueryStatisticsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$getQueryStatistics$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceLfTagsResponse getResourceLFTags(GetResourceLfTagsRequest getResourceLfTagsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceLfTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, getResourceLfTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceLFTags");
            GetResourceLfTagsResponse getResourceLfTagsResponse = (GetResourceLfTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceLFTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResourceLfTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourceLfTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourceLfTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$getResourceLFTags$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTableObjectsResponse getTableObjects(GetTableObjectsRequest getTableObjectsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTableObjectsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, getTableObjectsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTableObjects");
            GetTableObjectsResponse getTableObjectsResponse = (GetTableObjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTableObjects").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTableObjectsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTableObjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTableObjectsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$getTableObjects$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetTableObjectsIterable getTableObjectsPaginator(GetTableObjectsRequest getTableObjectsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException, AwsServiceException, SdkClientException, LakeFormationException {
        return new GetTableObjectsIterable(this, this.applyPaginatorUserAgent(getTableObjectsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTemporaryGluePartitionCredentialsResponse getTemporaryGluePartitionCredentials(GetTemporaryGluePartitionCredentialsRequest getTemporaryGluePartitionCredentialsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, PermissionTypeMismatchException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTemporaryGluePartitionCredentialsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, getTemporaryGluePartitionCredentialsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTemporaryGluePartitionCredentials");
            GetTemporaryGluePartitionCredentialsResponse getTemporaryGluePartitionCredentialsResponse = (GetTemporaryGluePartitionCredentialsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemporaryGluePartitionCredentials").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTemporaryGluePartitionCredentialsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTemporaryGluePartitionCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTemporaryGluePartitionCredentialsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$getTemporaryGluePartitionCredentials$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTemporaryGlueTableCredentialsResponse getTemporaryGlueTableCredentials(GetTemporaryGlueTableCredentialsRequest getTemporaryGlueTableCredentialsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, PermissionTypeMismatchException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTemporaryGlueTableCredentialsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, getTemporaryGlueTableCredentialsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTemporaryGlueTableCredentials");
            GetTemporaryGlueTableCredentialsResponse getTemporaryGlueTableCredentialsResponse = (GetTemporaryGlueTableCredentialsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemporaryGlueTableCredentials").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTemporaryGlueTableCredentialsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTemporaryGlueTableCredentialsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTemporaryGlueTableCredentialsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$getTemporaryGlueTableCredentials$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT getWorkUnitResults(GetWorkUnitResultsRequest getWorkUnitResultsRequest, ResponseTransformer<GetWorkUnitResultsResponse, ReturnT> responseTransformer) throws InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkUnitResultsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, getWorkUnitResultsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkUnitResults");
            String hostPrefix = "data-";
            String resolvedHostExpression = "data-";
            Object object = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkUnitResults").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getWorkUnitResultsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetWorkUnitResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)), responseTransformer);
            return (ReturnT)object;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$getWorkUnitResults$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWorkUnitsResponse getWorkUnits(GetWorkUnitsRequest getWorkUnitsRequest) throws WorkUnitsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkUnitsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, getWorkUnitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkUnits");
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            GetWorkUnitsResponse getWorkUnitsResponse = (GetWorkUnitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkUnits").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getWorkUnitsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetWorkUnitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getWorkUnitsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$getWorkUnits$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetWorkUnitsIterable getWorkUnitsPaginator(GetWorkUnitsRequest getWorkUnitsRequest) throws WorkUnitsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, AwsServiceException, SdkClientException, LakeFormationException {
        return new GetWorkUnitsIterable(this, this.applyPaginatorUserAgent(getWorkUnitsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GrantPermissionsResponse grantPermissions(GrantPermissionsRequest grantPermissionsRequest) throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GrantPermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, grantPermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GrantPermissions");
            GrantPermissionsResponse grantPermissionsResponse = (GrantPermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GrantPermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)grantPermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GrantPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return grantPermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$grantPermissions$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDataCellsFilterResponse listDataCellsFilter(ListDataCellsFilterRequest listDataCellsFilterRequest) throws InvalidInputException, OperationTimeoutException, InternalServiceException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataCellsFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, listDataCellsFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDataCellsFilter");
            ListDataCellsFilterResponse listDataCellsFilterResponse = (ListDataCellsFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataCellsFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDataCellsFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDataCellsFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDataCellsFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$listDataCellsFilter$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDataCellsFilterIterable listDataCellsFilterPaginator(ListDataCellsFilterRequest listDataCellsFilterRequest) throws InvalidInputException, OperationTimeoutException, InternalServiceException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return new ListDataCellsFilterIterable(this, this.applyPaginatorUserAgent(listDataCellsFilterRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLfTagsResponse listLFTags(ListLfTagsRequest listLfTagsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLfTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, listLfTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLFTags");
            ListLfTagsResponse listLfTagsResponse = (ListLfTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLFTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLfTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLfTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLfTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$listLFTags$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListLFTagsIterable listLFTagsPaginator(ListLfTagsRequest listLfTagsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return new ListLFTagsIterable(this, this.applyPaginatorUserAgent(listLfTagsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPermissionsResponse listPermissions(ListPermissionsRequest listPermissionsRequest) throws InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, listPermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPermissions");
            ListPermissionsResponse listPermissionsResponse = (ListPermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$listPermissions$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPermissionsIterable listPermissionsPaginator(ListPermissionsRequest listPermissionsRequest) throws InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        return new ListPermissionsIterable(this, this.applyPaginatorUserAgent(listPermissionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourcesResponse listResources(ListResourcesRequest listResourcesRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, listResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResources");
            ListResourcesResponse listResourcesResponse = (ListResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$listResources$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListResourcesIterable listResourcesPaginator(ListResourcesRequest listResourcesRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return new ListResourcesIterable(this, this.applyPaginatorUserAgent(listResourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTableStorageOptimizersResponse listTableStorageOptimizers(ListTableStorageOptimizersRequest listTableStorageOptimizersRequest) throws EntityNotFoundException, InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTableStorageOptimizersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, listTableStorageOptimizersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTableStorageOptimizers");
            ListTableStorageOptimizersResponse listTableStorageOptimizersResponse = (ListTableStorageOptimizersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTableStorageOptimizers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTableStorageOptimizersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTableStorageOptimizersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTableStorageOptimizersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$listTableStorageOptimizers$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTableStorageOptimizersIterable listTableStorageOptimizersPaginator(ListTableStorageOptimizersRequest listTableStorageOptimizersRequest) throws EntityNotFoundException, InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        return new ListTableStorageOptimizersIterable(this, this.applyPaginatorUserAgent(listTableStorageOptimizersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTransactionsResponse listTransactions(ListTransactionsRequest listTransactionsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTransactionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, listTransactionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTransactions");
            ListTransactionsResponse listTransactionsResponse = (ListTransactionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTransactions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTransactionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTransactionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTransactionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$listTransactions$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTransactionsIterable listTransactionsPaginator(ListTransactionsRequest listTransactionsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return new ListTransactionsIterable(this, this.applyPaginatorUserAgent(listTransactionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutDataLakeSettingsResponse putDataLakeSettings(PutDataLakeSettingsRequest putDataLakeSettingsRequest) throws InternalServiceException, InvalidInputException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDataLakeSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, putDataLakeSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDataLakeSettings");
            PutDataLakeSettingsResponse putDataLakeSettingsResponse = (PutDataLakeSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDataLakeSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDataLakeSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutDataLakeSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putDataLakeSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$putDataLakeSettings$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterResourceResponse registerResource(RegisterResourceRequest registerResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AlreadyExistsException, EntityNotFoundException, ResourceNumberLimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, registerResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterResource");
            RegisterResourceResponse registerResourceResponse = (RegisterResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$registerResource$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveLfTagsFromResourceResponse removeLFTagsFromResource(RemoveLfTagsFromResourceRequest removeLfTagsFromResourceRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveLfTagsFromResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, removeLfTagsFromResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveLFTagsFromResource");
            RemoveLfTagsFromResourceResponse removeLfTagsFromResourceResponse = (RemoveLfTagsFromResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveLFTagsFromResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeLfTagsFromResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveLfTagsFromResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeLfTagsFromResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$removeLFTagsFromResource$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevokePermissionsResponse revokePermissions(RevokePermissionsRequest revokePermissionsRequest) throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokePermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, revokePermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokePermissions");
            RevokePermissionsResponse revokePermissionsResponse = (RevokePermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokePermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)revokePermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RevokePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return revokePermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$revokePermissions$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchDatabasesByLfTagsResponse searchDatabasesByLFTags(SearchDatabasesByLfTagsRequest searchDatabasesByLfTagsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchDatabasesByLfTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, searchDatabasesByLfTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchDatabasesByLFTags");
            SearchDatabasesByLfTagsResponse searchDatabasesByLfTagsResponse = (SearchDatabasesByLfTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchDatabasesByLFTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchDatabasesByLfTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchDatabasesByLfTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchDatabasesByLfTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$searchDatabasesByLFTags$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public SearchDatabasesByLFTagsIterable searchDatabasesByLFTagsPaginator(SearchDatabasesByLfTagsRequest searchDatabasesByLfTagsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return new SearchDatabasesByLFTagsIterable(this, this.applyPaginatorUserAgent(searchDatabasesByLfTagsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchTablesByLfTagsResponse searchTablesByLFTags(SearchTablesByLfTagsRequest searchTablesByLfTagsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchTablesByLfTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, searchTablesByLfTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchTablesByLFTags");
            SearchTablesByLfTagsResponse searchTablesByLfTagsResponse = (SearchTablesByLfTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchTablesByLFTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchTablesByLfTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchTablesByLfTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchTablesByLfTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$searchTablesByLFTags$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public SearchTablesByLFTagsIterable searchTablesByLFTagsPaginator(SearchTablesByLfTagsRequest searchTablesByLfTagsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return new SearchTablesByLFTagsIterable(this, this.applyPaginatorUserAgent(searchTablesByLfTagsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartQueryPlanningResponse startQueryPlanning(StartQueryPlanningRequest startQueryPlanningRequest) throws InternalServiceException, InvalidInputException, AccessDeniedException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartQueryPlanningResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, startQueryPlanningRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartQueryPlanning");
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            StartQueryPlanningResponse startQueryPlanningResponse = (StartQueryPlanningResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartQueryPlanning").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)startQueryPlanningRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartQueryPlanningRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startQueryPlanningResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$startQueryPlanning$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTransactionResponse startTransaction(StartTransactionRequest startTransactionRequest) throws InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTransactionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, startTransactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTransaction");
            StartTransactionResponse startTransactionResponse = (StartTransactionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTransaction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startTransactionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartTransactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startTransactionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$startTransaction$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDataCellsFilterResponse updateDataCellsFilter(UpdateDataCellsFilterRequest updateDataCellsFilterRequest) throws ConcurrentModificationException, InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataCellsFilterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, updateDataCellsFilterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataCellsFilter");
            UpdateDataCellsFilterResponse updateDataCellsFilterResponse = (UpdateDataCellsFilterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataCellsFilter").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDataCellsFilterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDataCellsFilterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDataCellsFilterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$updateDataCellsFilter$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLfTagResponse updateLFTag(UpdateLfTagRequest updateLfTagRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, ConcurrentModificationException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLfTagResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, updateLfTagRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLFTag");
            UpdateLfTagResponse updateLfTagResponse = (UpdateLfTagResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLFTag").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateLfTagRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLfTagRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLfTagResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$updateLFTag$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateResourceResponse updateResource(UpdateResourceRequest updateResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, updateResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateResource");
            UpdateResourceResponse updateResourceResponse = (UpdateResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$updateResource$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTableObjectsResponse updateTableObjects(UpdateTableObjectsRequest updateTableObjectsRequest) throws InternalServiceException, InvalidInputException, OperationTimeoutException, EntityNotFoundException, TransactionCommittedException, TransactionCanceledException, TransactionCommitInProgressException, ResourceNotReadyException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableObjectsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, updateTableObjectsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTableObjects");
            UpdateTableObjectsResponse updateTableObjectsResponse = (UpdateTableObjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTableObjects").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTableObjectsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTableObjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTableObjectsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$updateTableObjects$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTableStorageOptimizerResponse updateTableStorageOptimizer(UpdateTableStorageOptimizerRequest updateTableStorageOptimizerRequest) throws EntityNotFoundException, InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableStorageOptimizerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationClient.resolveMetricPublishers(this.clientConfiguration, updateTableStorageOptimizerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTableStorageOptimizer");
            UpdateTableStorageOptimizerResponse updateTableStorageOptimizerResponse = (UpdateTableStorageOptimizerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTableStorageOptimizer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTableStorageOptimizerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTableStorageOptimizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTableStorageOptimizerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultLakeFormationClient.lambda$updateTableStorageOptimizer$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends LakeFormationRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.89").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((LakeFormationRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "lakeformation";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(LakeFormationException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").exceptionBuilderSupplier(TransactionCommitInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").exceptionBuilderSupplier(ResourceNotReadyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottledException").exceptionBuilderSupplier(ThrottledException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredException").exceptionBuilderSupplier(ExpiredException::builder).httpStatusCode(Integer.valueOf(410)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).httpStatusCode(Integer.valueOf(420)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TransactionCanceledException").exceptionBuilderSupplier(TransactionCanceledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).httpStatusCode(Integer.valueOf(420)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TransactionCommittedException").exceptionBuilderSupplier(TransactionCommittedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final LakeFormationServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateTableStorageOptimizer$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTableObjects$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateResource$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLFTag$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDataCellsFilter$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTransaction$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startQueryPlanning$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchTablesByLFTags$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchDatabasesByLFTags$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokePermissions$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeLFTagsFromResource$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerResource$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putDataLakeSettings$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTransactions$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTableStorageOptimizers$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResources$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPermissions$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLFTags$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDataCellsFilter$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$grantPermissions$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkUnits$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkUnitResults$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTemporaryGlueTableCredentials$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTemporaryGluePartitionCredentials$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTableObjects$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceLFTags$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getQueryStatistics$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getQueryState$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLFTag$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEffectivePermissionsForPath$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataLakeSettings$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataCellsFilter$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$extendTransaction$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTransaction$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeResource$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterResource$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteObjectsOnCancel$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLFTag$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataCellsFilter$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLFTag$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataCellsFilter$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$commitTransaction$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelTransaction$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchRevokePermissions$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGrantPermissions$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$assumeDecoratedRoleWithSAML$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addLFTagsToResource$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

