/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResourceRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, UpdateResourceRequest> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdateResourceRequest.getter(UpdateResourceRequest::roleArn)).setter(UpdateResourceRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(UpdateResourceRequest.getter(UpdateResourceRequest::resourceArn)).setter(UpdateResourceRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Boolean> WITH_FEDERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WithFederation").getter(UpdateResourceRequest.getter(UpdateResourceRequest::withFederation)).setter(UpdateResourceRequest.setter(Builder::withFederation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithFederation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, RESOURCE_ARN_FIELD, WITH_FEDERATION_FIELD));
    private final String roleArn;
    private final String resourceArn;
    private final Boolean withFederation;

    private UpdateResourceRequest(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.resourceArn = builder.resourceArn;
        this.withFederation = builder.withFederation;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Boolean withFederation() {
        return this.withFederation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.withFederation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceRequest)) {
            return false;
        }
        UpdateResourceRequest other = (UpdateResourceRequest)((Object)obj);
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.withFederation(), other.withFederation());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResourceRequest").add("RoleArn", (Object)this.roleArn()).add("ResourceArn", (Object)this.resourceArn()).add("WithFederation", (Object)this.withFederation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "WithFederation": {
                return Optional.ofNullable(clazz.cast(this.withFederation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceRequest, T> g) {
        return obj -> g.apply((UpdateResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private String roleArn;
        private String resourceArn;
        private Boolean withFederation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceRequest model) {
            super(model);
            this.roleArn(model.roleArn);
            this.resourceArn(model.resourceArn);
            this.withFederation(model.withFederation);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Boolean getWithFederation() {
            return this.withFederation;
        }

        public final void setWithFederation(Boolean withFederation) {
            this.withFederation = withFederation;
        }

        @Override
        public final Builder withFederation(Boolean withFederation) {
            this.withFederation = withFederation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceRequest build() {
            return new UpdateResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResourceRequest> {
        public Builder roleArn(String var1);

        public Builder resourceArn(String var1);

        public Builder withFederation(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

