/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing a list of partition values and table objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartitionObjects implements SdkPojo, Serializable,
        ToCopyableBuilder<PartitionObjects.Builder, PartitionObjects> {
    private static final SdkField<List<String>> PARTITION_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PartitionValues")
            .getter(getter(PartitionObjects::partitionValues))
            .setter(setter(Builder::partitionValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TableObject>> OBJECTS_FIELD = SdkField
            .<List<TableObject>> builder(MarshallingType.LIST)
            .memberName("Objects")
            .getter(getter(PartitionObjects::objects))
            .setter(setter(Builder::objects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Objects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableObject> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableObject::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_VALUES_FIELD,
            OBJECTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> partitionValues;

    private final List<TableObject> objects;

    private PartitionObjects(BuilderImpl builder) {
        this.partitionValues = builder.partitionValues;
        this.objects = builder.objects;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartitionValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartitionValues() {
        return partitionValues != null && !(partitionValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of partition values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitionValues} method.
     * </p>
     * 
     * @return A list of partition values.
     */
    public final List<String> partitionValues() {
        return partitionValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the Objects property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasObjects() {
        return objects != null && !(objects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of table objects
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObjects} method.
     * </p>
     * 
     * @return A list of table objects
     */
    public final List<TableObject> objects() {
        return objects;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionValues() ? partitionValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasObjects() ? objects() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionObjects)) {
            return false;
        }
        PartitionObjects other = (PartitionObjects) obj;
        return hasPartitionValues() == other.hasPartitionValues() && Objects.equals(partitionValues(), other.partitionValues())
                && hasObjects() == other.hasObjects() && Objects.equals(objects(), other.objects());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PartitionObjects").add("PartitionValues", hasPartitionValues() ? partitionValues() : null)
                .add("Objects", hasObjects() ? objects() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PartitionValues":
            return Optional.ofNullable(clazz.cast(partitionValues()));
        case "Objects":
            return Optional.ofNullable(clazz.cast(objects()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PartitionObjects, T> g) {
        return obj -> g.apply((PartitionObjects) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartitionObjects> {
        /**
         * <p>
         * A list of partition values.
         * </p>
         * 
         * @param partitionValues
         *        A list of partition values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionValues(Collection<String> partitionValues);

        /**
         * <p>
         * A list of partition values.
         * </p>
         * 
         * @param partitionValues
         *        A list of partition values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionValues(String... partitionValues);

        /**
         * <p>
         * A list of table objects
         * </p>
         * 
         * @param objects
         *        A list of table objects
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objects(Collection<TableObject> objects);

        /**
         * <p>
         * A list of table objects
         * </p>
         * 
         * @param objects
         *        A list of table objects
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objects(TableObject... objects);

        /**
         * <p>
         * A list of table objects
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lakeformation.model.TableObject.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lakeformation.model.TableObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lakeformation.model.TableObject.Builder#build()} is called immediately
         * and its result is passed to {@link #objects(List<TableObject>)}.
         * 
         * @param objects
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lakeformation.model.TableObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objects(java.util.Collection<TableObject>)
         */
        Builder objects(Consumer<TableObject.Builder>... objects);
    }

    static final class BuilderImpl implements Builder {
        private List<String> partitionValues = DefaultSdkAutoConstructList.getInstance();

        private List<TableObject> objects = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PartitionObjects model) {
            partitionValues(model.partitionValues);
            objects(model.objects);
        }

        public final Collection<String> getPartitionValues() {
            if (partitionValues instanceof SdkAutoConstructList) {
                return null;
            }
            return partitionValues;
        }

        public final void setPartitionValues(Collection<String> partitionValues) {
            this.partitionValues = PartitionValuesListCopier.copy(partitionValues);
        }

        @Override
        public final Builder partitionValues(Collection<String> partitionValues) {
            this.partitionValues = PartitionValuesListCopier.copy(partitionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionValues(String... partitionValues) {
            partitionValues(Arrays.asList(partitionValues));
            return this;
        }

        public final List<TableObject.Builder> getObjects() {
            List<TableObject.Builder> result = TableObjectListCopier.copyToBuilder(this.objects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObjects(Collection<TableObject.BuilderImpl> objects) {
            this.objects = TableObjectListCopier.copyFromBuilder(objects);
        }

        @Override
        public final Builder objects(Collection<TableObject> objects) {
            this.objects = TableObjectListCopier.copy(objects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(TableObject... objects) {
            objects(Arrays.asList(objects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(Consumer<TableObject.Builder>... objects) {
            objects(Stream.of(objects).map(c -> TableObject.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PartitionObjects build() {
            return new PartitionObjects(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
