/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceLfTagsRequest extends LakeFormationRequest implements
        ToCopyableBuilder<GetResourceLfTagsRequest.Builder, GetResourceLfTagsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(GetResourceLfTagsRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .memberName("Resource").getter(getter(GetResourceLfTagsRequest::resource)).setter(setter(Builder::resource))
            .constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<Boolean> SHOW_ASSIGNED_LF_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ShowAssignedLFTags").getter(getter(GetResourceLfTagsRequest::showAssignedLFTags))
            .setter(setter(Builder::showAssignedLFTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowAssignedLFTags").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            RESOURCE_FIELD, SHOW_ASSIGNED_LF_TAGS_FIELD));

    private final String catalogId;

    private final Resource resource;

    private final Boolean showAssignedLFTags;

    private GetResourceLfTagsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.resource = builder.resource;
        this.showAssignedLFTags = builder.showAssignedLFTags;
    }

    /**
     * <p>
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
     * store. It contains database definitions, table definitions, and other control information to manage your Lake
     * Formation environment.
     * </p>
     * 
     * @return The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
     *         metadata store. It contains database definitions, table definitions, and other control information to
     *         manage your Lake Formation environment.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The database, table, or column resource for which you want to return LF-tags.
     * </p>
     * 
     * @return The database, table, or column resource for which you want to return LF-tags.
     */
    public final Resource resource() {
        return resource;
    }

    /**
     * <p>
     * Indicates whether to show the assigned LF-tags.
     * </p>
     * 
     * @return Indicates whether to show the assigned LF-tags.
     */
    public final Boolean showAssignedLFTags() {
        return showAssignedLFTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(showAssignedLFTags());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceLfTagsRequest)) {
            return false;
        }
        GetResourceLfTagsRequest other = (GetResourceLfTagsRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(resource(), other.resource())
                && Objects.equals(showAssignedLFTags(), other.showAssignedLFTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceLfTagsRequest").add("CatalogId", catalogId()).add("Resource", resource())
                .add("ShowAssignedLFTags", showAssignedLFTags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "ShowAssignedLFTags":
            return Optional.ofNullable(clazz.cast(showAssignedLFTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceLfTagsRequest, T> g) {
        return obj -> g.apply((GetResourceLfTagsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceLfTagsRequest> {
        /**
         * <p>
         * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
         * store. It contains database definitions, table definitions, and other control information to manage your Lake
         * Formation environment.
         * </p>
         * 
         * @param catalogId
         *        The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
         *        metadata store. It contains database definitions, table definitions, and other control information to
         *        manage your Lake Formation environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The database, table, or column resource for which you want to return LF-tags.
         * </p>
         * 
         * @param resource
         *        The database, table, or column resource for which you want to return LF-tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(Resource resource);

        /**
         * <p>
         * The database, table, or column resource for which you want to return LF-tags.
         * </p>
         * This is a convenience method that creates an instance of the {@link Resource.Builder} avoiding the need to
         * create one manually via {@link Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #resource(Resource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(Resource)
         */
        default Builder resource(Consumer<Resource.Builder> resource) {
            return resource(Resource.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * Indicates whether to show the assigned LF-tags.
         * </p>
         * 
         * @param showAssignedLFTags
         *        Indicates whether to show the assigned LF-tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showAssignedLFTags(Boolean showAssignedLFTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String catalogId;

        private Resource resource;

        private Boolean showAssignedLFTags;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceLfTagsRequest model) {
            super(model);
            catalogId(model.catalogId);
            resource(model.resource);
            showAssignedLFTags(model.showAssignedLFTags);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final Resource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final Boolean getShowAssignedLFTags() {
            return showAssignedLFTags;
        }

        public final void setShowAssignedLFTags(Boolean showAssignedLFTags) {
            this.showAssignedLFTags = showAssignedLFTags;
        }

        @Override
        public final Builder showAssignedLFTags(Boolean showAssignedLFTags) {
            this.showAssignedLFTags = showAssignedLFTags;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceLfTagsRequest build() {
            return new GetResourceLfTagsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
