/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlanningStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlanningStatistics> {
    private static final SdkField<Long> ESTIMATED_DATA_TO_SCAN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedDataToScanBytes").getter(PlanningStatistics.getter(PlanningStatistics::estimatedDataToScanBytes)).setter(PlanningStatistics.setter(Builder::estimatedDataToScanBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedDataToScanBytes").build()}).build();
    private static final SdkField<Long> PLANNING_TIME_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PlanningTimeMillis").getter(PlanningStatistics.getter(PlanningStatistics::planningTimeMillis)).setter(PlanningStatistics.setter(Builder::planningTimeMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanningTimeMillis").build()}).build();
    private static final SdkField<Long> QUEUE_TIME_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("QueueTimeMillis").getter(PlanningStatistics.getter(PlanningStatistics::queueTimeMillis)).setter(PlanningStatistics.setter(Builder::queueTimeMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueTimeMillis").build()}).build();
    private static final SdkField<Long> WORK_UNITS_GENERATED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("WorkUnitsGeneratedCount").getter(PlanningStatistics.getter(PlanningStatistics::workUnitsGeneratedCount)).setter(PlanningStatistics.setter(Builder::workUnitsGeneratedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkUnitsGeneratedCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ESTIMATED_DATA_TO_SCAN_BYTES_FIELD, PLANNING_TIME_MILLIS_FIELD, QUEUE_TIME_MILLIS_FIELD, WORK_UNITS_GENERATED_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long estimatedDataToScanBytes;
    private final Long planningTimeMillis;
    private final Long queueTimeMillis;
    private final Long workUnitsGeneratedCount;

    private PlanningStatistics(BuilderImpl builder) {
        this.estimatedDataToScanBytes = builder.estimatedDataToScanBytes;
        this.planningTimeMillis = builder.planningTimeMillis;
        this.queueTimeMillis = builder.queueTimeMillis;
        this.workUnitsGeneratedCount = builder.workUnitsGeneratedCount;
    }

    public final Long estimatedDataToScanBytes() {
        return this.estimatedDataToScanBytes;
    }

    public final Long planningTimeMillis() {
        return this.planningTimeMillis;
    }

    public final Long queueTimeMillis() {
        return this.queueTimeMillis;
    }

    public final Long workUnitsGeneratedCount() {
        return this.workUnitsGeneratedCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedDataToScanBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.planningTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.workUnitsGeneratedCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlanningStatistics)) {
            return false;
        }
        PlanningStatistics other = (PlanningStatistics)obj;
        return Objects.equals(this.estimatedDataToScanBytes(), other.estimatedDataToScanBytes()) && Objects.equals(this.planningTimeMillis(), other.planningTimeMillis()) && Objects.equals(this.queueTimeMillis(), other.queueTimeMillis()) && Objects.equals(this.workUnitsGeneratedCount(), other.workUnitsGeneratedCount());
    }

    public final String toString() {
        return ToString.builder((String)"PlanningStatistics").add("EstimatedDataToScanBytes", (Object)this.estimatedDataToScanBytes()).add("PlanningTimeMillis", (Object)this.planningTimeMillis()).add("QueueTimeMillis", (Object)this.queueTimeMillis()).add("WorkUnitsGeneratedCount", (Object)this.workUnitsGeneratedCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EstimatedDataToScanBytes": {
                return Optional.ofNullable(clazz.cast(this.estimatedDataToScanBytes()));
            }
            case "PlanningTimeMillis": {
                return Optional.ofNullable(clazz.cast(this.planningTimeMillis()));
            }
            case "QueueTimeMillis": {
                return Optional.ofNullable(clazz.cast(this.queueTimeMillis()));
            }
            case "WorkUnitsGeneratedCount": {
                return Optional.ofNullable(clazz.cast(this.workUnitsGeneratedCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlanningStatistics, T> g) {
        return obj -> g.apply((PlanningStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long estimatedDataToScanBytes;
        private Long planningTimeMillis;
        private Long queueTimeMillis;
        private Long workUnitsGeneratedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PlanningStatistics model) {
            this.estimatedDataToScanBytes(model.estimatedDataToScanBytes);
            this.planningTimeMillis(model.planningTimeMillis);
            this.queueTimeMillis(model.queueTimeMillis);
            this.workUnitsGeneratedCount(model.workUnitsGeneratedCount);
        }

        public final Long getEstimatedDataToScanBytes() {
            return this.estimatedDataToScanBytes;
        }

        public final void setEstimatedDataToScanBytes(Long estimatedDataToScanBytes) {
            this.estimatedDataToScanBytes = estimatedDataToScanBytes;
        }

        @Override
        public final Builder estimatedDataToScanBytes(Long estimatedDataToScanBytes) {
            this.estimatedDataToScanBytes = estimatedDataToScanBytes;
            return this;
        }

        public final Long getPlanningTimeMillis() {
            return this.planningTimeMillis;
        }

        public final void setPlanningTimeMillis(Long planningTimeMillis) {
            this.planningTimeMillis = planningTimeMillis;
        }

        @Override
        public final Builder planningTimeMillis(Long planningTimeMillis) {
            this.planningTimeMillis = planningTimeMillis;
            return this;
        }

        public final Long getQueueTimeMillis() {
            return this.queueTimeMillis;
        }

        public final void setQueueTimeMillis(Long queueTimeMillis) {
            this.queueTimeMillis = queueTimeMillis;
        }

        @Override
        public final Builder queueTimeMillis(Long queueTimeMillis) {
            this.queueTimeMillis = queueTimeMillis;
            return this;
        }

        public final Long getWorkUnitsGeneratedCount() {
            return this.workUnitsGeneratedCount;
        }

        public final void setWorkUnitsGeneratedCount(Long workUnitsGeneratedCount) {
            this.workUnitsGeneratedCount = workUnitsGeneratedCount;
        }

        @Override
        public final Builder workUnitsGeneratedCount(Long workUnitsGeneratedCount) {
            this.workUnitsGeneratedCount = workUnitsGeneratedCount;
            return this;
        }

        public PlanningStatistics build() {
            return new PlanningStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlanningStatistics> {
        public Builder estimatedDataToScanBytes(Long var1);

        public Builder planningTimeMillis(Long var1);

        public Builder queueTimeMillis(Long var1);

        public Builder workUnitsGeneratedCount(Long var1);
    }
}

