/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.ColumnNamesCopier;
import software.amazon.awssdk.services.lakeformation.model.ColumnWildcard;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableWithColumnsResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableWithColumnsResource> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(TableWithColumnsResource.getter(TableWithColumnsResource::catalogId)).setter(TableWithColumnsResource.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(TableWithColumnsResource.getter(TableWithColumnsResource::databaseName)).setter(TableWithColumnsResource.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TableWithColumnsResource.getter(TableWithColumnsResource::name)).setter(TableWithColumnsResource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> COLUMN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnNames").getter(TableWithColumnsResource.getter(TableWithColumnsResource::columnNames)).setter(TableWithColumnsResource.setter(Builder::columnNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ColumnWildcard> COLUMN_WILDCARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColumnWildcard").getter(TableWithColumnsResource.getter(TableWithColumnsResource::columnWildcard)).setter(TableWithColumnsResource.setter(Builder::columnWildcard)).constructor(ColumnWildcard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnWildcard").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, NAME_FIELD, COLUMN_NAMES_FIELD, COLUMN_WILDCARD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String catalogId;
    private final String databaseName;
    private final String name;
    private final List<String> columnNames;
    private final ColumnWildcard columnWildcard;

    private TableWithColumnsResource(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.name = builder.name;
        this.columnNames = builder.columnNames;
        this.columnWildcard = builder.columnWildcard;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasColumnNames() {
        return this.columnNames != null && !(this.columnNames instanceof SdkAutoConstructList);
    }

    public final List<String> columnNames() {
        return this.columnNames;
    }

    public final ColumnWildcard columnWildcard() {
        return this.columnWildcard;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnNames() ? this.columnNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.columnWildcard());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableWithColumnsResource)) {
            return false;
        }
        TableWithColumnsResource other = (TableWithColumnsResource)obj;
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.name(), other.name()) && this.hasColumnNames() == other.hasColumnNames() && Objects.equals(this.columnNames(), other.columnNames()) && Objects.equals(this.columnWildcard(), other.columnWildcard());
    }

    public final String toString() {
        return ToString.builder((String)"TableWithColumnsResource").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("Name", (Object)this.name()).add("ColumnNames", this.hasColumnNames() ? this.columnNames() : null).add("ColumnWildcard", (Object)this.columnWildcard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ColumnNames": {
                return Optional.ofNullable(clazz.cast(this.columnNames()));
            }
            case "ColumnWildcard": {
                return Optional.ofNullable(clazz.cast(this.columnWildcard()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableWithColumnsResource, T> g) {
        return obj -> g.apply((TableWithColumnsResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String name;
        private List<String> columnNames = DefaultSdkAutoConstructList.getInstance();
        private ColumnWildcard columnWildcard;

        private BuilderImpl() {
        }

        private BuilderImpl(TableWithColumnsResource model) {
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.name(model.name);
            this.columnNames(model.columnNames);
            this.columnWildcard(model.columnWildcard);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        @Transient
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getColumnNames() {
            if (this.columnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnNames;
        }

        public final void setColumnNames(Collection<String> columnNames) {
            this.columnNames = ColumnNamesCopier.copy(columnNames);
        }

        @Override
        @Transient
        public final Builder columnNames(Collection<String> columnNames) {
            this.columnNames = ColumnNamesCopier.copy(columnNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columnNames(String ... columnNames) {
            this.columnNames(Arrays.asList(columnNames));
            return this;
        }

        public final ColumnWildcard.Builder getColumnWildcard() {
            return this.columnWildcard != null ? this.columnWildcard.toBuilder() : null;
        }

        public final void setColumnWildcard(ColumnWildcard.BuilderImpl columnWildcard) {
            this.columnWildcard = columnWildcard != null ? columnWildcard.build() : null;
        }

        @Override
        @Transient
        public final Builder columnWildcard(ColumnWildcard columnWildcard) {
            this.columnWildcard = columnWildcard;
            return this;
        }

        public TableWithColumnsResource build() {
            return new TableWithColumnsResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableWithColumnsResource> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder name(String var1);

        public Builder columnNames(Collection<String> var1);

        public Builder columnNames(String ... var1);

        public Builder columnWildcard(ColumnWildcard var1);

        default public Builder columnWildcard(Consumer<ColumnWildcard.Builder> columnWildcard) {
            return this.columnWildcard((ColumnWildcard)((ColumnWildcard.Builder)ColumnWildcard.builder().applyMutation(columnWildcard)).build());
        }
    }
}

