/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.services.lakeformation.model.ResourceInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeResourceResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, DescribeResourceResponse> {
    private static final SdkField<ResourceInfo> RESOURCE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceInfo").getter(DescribeResourceResponse.getter(DescribeResourceResponse::resourceInfo)).setter(DescribeResourceResponse.setter(Builder::resourceInfo)).constructor(ResourceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_INFO_FIELD));
    private final ResourceInfo resourceInfo;

    private DescribeResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resourceInfo = builder.resourceInfo;
    }

    public final ResourceInfo resourceInfo() {
        return this.resourceInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceResponse)) {
            return false;
        }
        DescribeResourceResponse other = (DescribeResourceResponse)((Object)obj);
        return Objects.equals(this.resourceInfo(), other.resourceInfo());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeResourceResponse").add("ResourceInfo", (Object)this.resourceInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceInfo": {
                return Optional.ofNullable(clazz.cast(this.resourceInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceResponse, T> g) {
        return obj -> g.apply((DescribeResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private ResourceInfo resourceInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceResponse model) {
            super(model);
            this.resourceInfo(model.resourceInfo);
        }

        public final ResourceInfo.Builder getResourceInfo() {
            return this.resourceInfo != null ? this.resourceInfo.toBuilder() : null;
        }

        public final void setResourceInfo(ResourceInfo.BuilderImpl resourceInfo) {
            this.resourceInfo = resourceInfo != null ? resourceInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceInfo(ResourceInfo resourceInfo) {
            this.resourceInfo = resourceInfo;
            return this;
        }

        @Override
        public DescribeResourceResponse build() {
            return new DescribeResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeResourceResponse> {
        public Builder resourceInfo(ResourceInfo var1);

        default public Builder resourceInfo(Consumer<ResourceInfo.Builder> resourceInfo) {
            return this.resourceInfo((ResourceInfo)((ResourceInfo.Builder)ResourceInfo.builder().applyMutation(resourceInfo)).build());
        }
    }
}

