/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse;

public class ListTableStorageOptimizersPublisher
implements SdkPublisher<ListTableStorageOptimizersResponse> {
    private final LakeFormationAsyncClient client;
    private final ListTableStorageOptimizersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTableStorageOptimizersPublisher(LakeFormationAsyncClient client, ListTableStorageOptimizersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTableStorageOptimizersPublisher(LakeFormationAsyncClient client, ListTableStorageOptimizersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTableStorageOptimizersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTableStorageOptimizersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTableStorageOptimizersResponseFetcher
    implements AsyncPageFetcher<ListTableStorageOptimizersResponse> {
        private ListTableStorageOptimizersResponseFetcher() {
        }

        public boolean hasNextPage(ListTableStorageOptimizersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTableStorageOptimizersResponse> nextPage(ListTableStorageOptimizersResponse previousPage) {
            if (previousPage == null) {
                return ListTableStorageOptimizersPublisher.this.client.listTableStorageOptimizers(ListTableStorageOptimizersPublisher.this.firstRequest);
            }
            return ListTableStorageOptimizersPublisher.this.client.listTableStorageOptimizers((ListTableStorageOptimizersRequest)((Object)ListTableStorageOptimizersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

