/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal;
import software.amazon.awssdk.services.lakeformation.model.DataLakePrincipalListCopier;
import software.amazon.awssdk.services.lakeformation.model.PrincipalPermissions;
import software.amazon.awssdk.services.lakeformation.model.PrincipalPermissionsListCopier;
import software.amazon.awssdk.services.lakeformation.model.TrustedResourceOwnersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataLakeSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataLakeSettings> {
    private static final SdkField<List<DataLakePrincipal>> DATA_LAKE_ADMINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataLakeAdmins").getter(DataLakeSettings.getter(DataLakeSettings::dataLakeAdmins)).setter(DataLakeSettings.setter(Builder::dataLakeAdmins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeAdmins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataLakePrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PrincipalPermissions>> CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CreateDatabaseDefaultPermissions").getter(DataLakeSettings.getter(DataLakeSettings::createDatabaseDefaultPermissions)).setter(DataLakeSettings.setter(Builder::createDatabaseDefaultPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDatabaseDefaultPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrincipalPermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PrincipalPermissions>> CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CreateTableDefaultPermissions").getter(DataLakeSettings.getter(DataLakeSettings::createTableDefaultPermissions)).setter(DataLakeSettings.setter(Builder::createTableDefaultPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTableDefaultPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrincipalPermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TRUSTED_RESOURCE_OWNERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrustedResourceOwners").getter(DataLakeSettings.getter(DataLakeSettings::trustedResourceOwners)).setter(DataLakeSettings.setter(Builder::trustedResourceOwners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedResourceOwners").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LAKE_ADMINS_FIELD, CREATE_DATABASE_DEFAULT_PERMISSIONS_FIELD, CREATE_TABLE_DEFAULT_PERMISSIONS_FIELD, TRUSTED_RESOURCE_OWNERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DataLakePrincipal> dataLakeAdmins;
    private final List<PrincipalPermissions> createDatabaseDefaultPermissions;
    private final List<PrincipalPermissions> createTableDefaultPermissions;
    private final List<String> trustedResourceOwners;

    private DataLakeSettings(BuilderImpl builder) {
        this.dataLakeAdmins = builder.dataLakeAdmins;
        this.createDatabaseDefaultPermissions = builder.createDatabaseDefaultPermissions;
        this.createTableDefaultPermissions = builder.createTableDefaultPermissions;
        this.trustedResourceOwners = builder.trustedResourceOwners;
    }

    public final boolean hasDataLakeAdmins() {
        return this.dataLakeAdmins != null && !(this.dataLakeAdmins instanceof SdkAutoConstructList);
    }

    public final List<DataLakePrincipal> dataLakeAdmins() {
        return this.dataLakeAdmins;
    }

    public final boolean hasCreateDatabaseDefaultPermissions() {
        return this.createDatabaseDefaultPermissions != null && !(this.createDatabaseDefaultPermissions instanceof SdkAutoConstructList);
    }

    public final List<PrincipalPermissions> createDatabaseDefaultPermissions() {
        return this.createDatabaseDefaultPermissions;
    }

    public final boolean hasCreateTableDefaultPermissions() {
        return this.createTableDefaultPermissions != null && !(this.createTableDefaultPermissions instanceof SdkAutoConstructList);
    }

    public final List<PrincipalPermissions> createTableDefaultPermissions() {
        return this.createTableDefaultPermissions;
    }

    public final boolean hasTrustedResourceOwners() {
        return this.trustedResourceOwners != null && !(this.trustedResourceOwners instanceof SdkAutoConstructList);
    }

    public final List<String> trustedResourceOwners() {
        return this.trustedResourceOwners;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataLakeAdmins() ? this.dataLakeAdmins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreateDatabaseDefaultPermissions() ? this.createDatabaseDefaultPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreateTableDefaultPermissions() ? this.createTableDefaultPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrustedResourceOwners() ? this.trustedResourceOwners() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeSettings)) {
            return false;
        }
        DataLakeSettings other = (DataLakeSettings)obj;
        return this.hasDataLakeAdmins() == other.hasDataLakeAdmins() && Objects.equals(this.dataLakeAdmins(), other.dataLakeAdmins()) && this.hasCreateDatabaseDefaultPermissions() == other.hasCreateDatabaseDefaultPermissions() && Objects.equals(this.createDatabaseDefaultPermissions(), other.createDatabaseDefaultPermissions()) && this.hasCreateTableDefaultPermissions() == other.hasCreateTableDefaultPermissions() && Objects.equals(this.createTableDefaultPermissions(), other.createTableDefaultPermissions()) && this.hasTrustedResourceOwners() == other.hasTrustedResourceOwners() && Objects.equals(this.trustedResourceOwners(), other.trustedResourceOwners());
    }

    public final String toString() {
        return ToString.builder((String)"DataLakeSettings").add("DataLakeAdmins", this.hasDataLakeAdmins() ? this.dataLakeAdmins() : null).add("CreateDatabaseDefaultPermissions", this.hasCreateDatabaseDefaultPermissions() ? this.createDatabaseDefaultPermissions() : null).add("CreateTableDefaultPermissions", this.hasCreateTableDefaultPermissions() ? this.createTableDefaultPermissions() : null).add("TrustedResourceOwners", this.hasTrustedResourceOwners() ? this.trustedResourceOwners() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataLakeAdmins": {
                return Optional.ofNullable(clazz.cast(this.dataLakeAdmins()));
            }
            case "CreateDatabaseDefaultPermissions": {
                return Optional.ofNullable(clazz.cast(this.createDatabaseDefaultPermissions()));
            }
            case "CreateTableDefaultPermissions": {
                return Optional.ofNullable(clazz.cast(this.createTableDefaultPermissions()));
            }
            case "TrustedResourceOwners": {
                return Optional.ofNullable(clazz.cast(this.trustedResourceOwners()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataLakeSettings, T> g) {
        return obj -> g.apply((DataLakeSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DataLakePrincipal> dataLakeAdmins = DefaultSdkAutoConstructList.getInstance();
        private List<PrincipalPermissions> createDatabaseDefaultPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<PrincipalPermissions> createTableDefaultPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<String> trustedResourceOwners = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeSettings model) {
            this.dataLakeAdmins(model.dataLakeAdmins);
            this.createDatabaseDefaultPermissions(model.createDatabaseDefaultPermissions);
            this.createTableDefaultPermissions(model.createTableDefaultPermissions);
            this.trustedResourceOwners(model.trustedResourceOwners);
        }

        public final List<DataLakePrincipal.Builder> getDataLakeAdmins() {
            List<DataLakePrincipal.Builder> result = DataLakePrincipalListCopier.copyToBuilder(this.dataLakeAdmins);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder dataLakeAdmins(Collection<DataLakePrincipal> dataLakeAdmins) {
            this.dataLakeAdmins = DataLakePrincipalListCopier.copy(dataLakeAdmins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataLakeAdmins(DataLakePrincipal ... dataLakeAdmins) {
            this.dataLakeAdmins(Arrays.asList(dataLakeAdmins));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataLakeAdmins(Consumer<DataLakePrincipal.Builder> ... dataLakeAdmins) {
            this.dataLakeAdmins(Stream.of(dataLakeAdmins).map(c -> (DataLakePrincipal)((DataLakePrincipal.Builder)DataLakePrincipal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDataLakeAdmins(Collection<DataLakePrincipal.BuilderImpl> dataLakeAdmins) {
            this.dataLakeAdmins = DataLakePrincipalListCopier.copyFromBuilder(dataLakeAdmins);
        }

        public final List<PrincipalPermissions.Builder> getCreateDatabaseDefaultPermissions() {
            List<PrincipalPermissions.Builder> result = PrincipalPermissionsListCopier.copyToBuilder(this.createDatabaseDefaultPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder createDatabaseDefaultPermissions(Collection<PrincipalPermissions> createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = PrincipalPermissionsListCopier.copy(createDatabaseDefaultPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDatabaseDefaultPermissions(PrincipalPermissions ... createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions(Arrays.asList(createDatabaseDefaultPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createDatabaseDefaultPermissions(Consumer<PrincipalPermissions.Builder> ... createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions(Stream.of(createDatabaseDefaultPermissions).map(c -> (PrincipalPermissions)((PrincipalPermissions.Builder)PrincipalPermissions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCreateDatabaseDefaultPermissions(Collection<PrincipalPermissions.BuilderImpl> createDatabaseDefaultPermissions) {
            this.createDatabaseDefaultPermissions = PrincipalPermissionsListCopier.copyFromBuilder(createDatabaseDefaultPermissions);
        }

        public final List<PrincipalPermissions.Builder> getCreateTableDefaultPermissions() {
            List<PrincipalPermissions.Builder> result = PrincipalPermissionsListCopier.copyToBuilder(this.createTableDefaultPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder createTableDefaultPermissions(Collection<PrincipalPermissions> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copy(createTableDefaultPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(PrincipalPermissions ... createTableDefaultPermissions) {
            this.createTableDefaultPermissions(Arrays.asList(createTableDefaultPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createTableDefaultPermissions(Consumer<PrincipalPermissions.Builder> ... createTableDefaultPermissions) {
            this.createTableDefaultPermissions(Stream.of(createTableDefaultPermissions).map(c -> (PrincipalPermissions)((PrincipalPermissions.Builder)PrincipalPermissions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCreateTableDefaultPermissions(Collection<PrincipalPermissions.BuilderImpl> createTableDefaultPermissions) {
            this.createTableDefaultPermissions = PrincipalPermissionsListCopier.copyFromBuilder(createTableDefaultPermissions);
        }

        public final Collection<String> getTrustedResourceOwners() {
            if (this.trustedResourceOwners instanceof SdkAutoConstructList) {
                return null;
            }
            return this.trustedResourceOwners;
        }

        @Override
        public final Builder trustedResourceOwners(Collection<String> trustedResourceOwners) {
            this.trustedResourceOwners = TrustedResourceOwnersCopier.copy(trustedResourceOwners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustedResourceOwners(String ... trustedResourceOwners) {
            this.trustedResourceOwners(Arrays.asList(trustedResourceOwners));
            return this;
        }

        public final void setTrustedResourceOwners(Collection<String> trustedResourceOwners) {
            this.trustedResourceOwners = TrustedResourceOwnersCopier.copy(trustedResourceOwners);
        }

        public DataLakeSettings build() {
            return new DataLakeSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataLakeSettings> {
        public Builder dataLakeAdmins(Collection<DataLakePrincipal> var1);

        public Builder dataLakeAdmins(DataLakePrincipal ... var1);

        public Builder dataLakeAdmins(Consumer<DataLakePrincipal.Builder> ... var1);

        public Builder createDatabaseDefaultPermissions(Collection<PrincipalPermissions> var1);

        public Builder createDatabaseDefaultPermissions(PrincipalPermissions ... var1);

        public Builder createDatabaseDefaultPermissions(Consumer<PrincipalPermissions.Builder> ... var1);

        public Builder createTableDefaultPermissions(Collection<PrincipalPermissions> var1);

        public Builder createTableDefaultPermissions(PrincipalPermissions ... var1);

        public Builder createTableDefaultPermissions(Consumer<PrincipalPermissions.Builder> ... var1);

        public Builder trustedResourceOwners(Collection<String> var1);

        public Builder trustedResourceOwners(String ... var1);
    }
}

