/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Permission {
    ALL("ALL"),
    SELECT("SELECT"),
    ALTER("ALTER"),
    DROP("DROP"),
    DELETE("DELETE"),
    INSERT("INSERT"),
    DESCRIBE("DESCRIBE"),
    CREATE_DATABASE("CREATE_DATABASE"),
    CREATE_TABLE("CREATE_TABLE"),
    DATA_LOCATION_ACCESS("DATA_LOCATION_ACCESS"),
    CREATE_TAG("CREATE_TAG"),
    ALTER_TAG("ALTER_TAG"),
    DELETE_TAG("DELETE_TAG"),
    DESCRIBE_TAG("DESCRIBE_TAG"),
    ASSOCIATE_TAG("ASSOCIATE_TAG"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Permission(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Permission fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Permission.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Permission> knownValues() {
        return Stream.of(Permission.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

