/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions;
import software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPermissionsResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, ListPermissionsResponse> {
    private static final SdkField<List<PrincipalResourcePermissions>> PRINCIPAL_RESOURCE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrincipalResourcePermissions").getter(ListPermissionsResponse.getter(ListPermissionsResponse::principalResourcePermissions)).setter(ListPermissionsResponse.setter(Builder::principalResourcePermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalResourcePermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrincipalResourcePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPermissionsResponse.getter(ListPermissionsResponse::nextToken)).setter(ListPermissionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_RESOURCE_PERMISSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<PrincipalResourcePermissions> principalResourcePermissions;
    private final String nextToken;

    private ListPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.principalResourcePermissions = builder.principalResourcePermissions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasPrincipalResourcePermissions() {
        return this.principalResourcePermissions != null && !(this.principalResourcePermissions instanceof SdkAutoConstructList);
    }

    public List<PrincipalResourcePermissions> principalResourcePermissions() {
        return this.principalResourcePermissions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipalResourcePermissions() ? this.principalResourcePermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionsResponse)) {
            return false;
        }
        ListPermissionsResponse other = (ListPermissionsResponse)((Object)obj);
        return this.hasPrincipalResourcePermissions() == other.hasPrincipalResourcePermissions() && Objects.equals(this.principalResourcePermissions(), other.principalResourcePermissions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListPermissionsResponse").add("PrincipalResourcePermissions", this.hasPrincipalResourcePermissions() ? this.principalResourcePermissions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrincipalResourcePermissions": {
                return Optional.ofNullable(clazz.cast(this.principalResourcePermissions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionsResponse, T> g) {
        return obj -> g.apply((ListPermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private List<PrincipalResourcePermissions> principalResourcePermissions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionsResponse model) {
            super(model);
            this.principalResourcePermissions(model.principalResourcePermissions);
            this.nextToken(model.nextToken);
        }

        public final Collection<PrincipalResourcePermissions.Builder> getPrincipalResourcePermissions() {
            if (this.principalResourcePermissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.principalResourcePermissions != null ? (Collection)this.principalResourcePermissions.stream().map(PrincipalResourcePermissions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder principalResourcePermissions(Collection<PrincipalResourcePermissions> principalResourcePermissions) {
            this.principalResourcePermissions = PrincipalResourcePermissionsListCopier.copy(principalResourcePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principalResourcePermissions(PrincipalResourcePermissions ... principalResourcePermissions) {
            this.principalResourcePermissions(Arrays.asList(principalResourcePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principalResourcePermissions(Consumer<PrincipalResourcePermissions.Builder> ... principalResourcePermissions) {
            this.principalResourcePermissions(Stream.of(principalResourcePermissions).map(c -> (PrincipalResourcePermissions)((PrincipalResourcePermissions.Builder)PrincipalResourcePermissions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrincipalResourcePermissions(Collection<PrincipalResourcePermissions.BuilderImpl> principalResourcePermissions) {
            this.principalResourcePermissions = PrincipalResourcePermissionsListCopier.copyFromBuilder(principalResourcePermissions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPermissionsResponse build() {
            return new ListPermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPermissionsResponse> {
        public Builder principalResourcePermissions(Collection<PrincipalResourcePermissions> var1);

        public Builder principalResourcePermissions(PrincipalResourcePermissions ... var1);

        public Builder principalResourcePermissions(Consumer<PrincipalResourcePermissions.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

