/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.ComparisonOperator;
import software.amazon.awssdk.services.lakeformation.model.FieldNameString;
import software.amazon.awssdk.services.lakeformation.model.StringValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterCondition> {
    private static final SdkField<String> FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Field").getter(FilterCondition.getter(FilterCondition::fieldAsString)).setter(FilterCondition.setter(Builder::field)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Field").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonOperator").getter(FilterCondition.getter(FilterCondition::comparisonOperatorAsString)).setter(FilterCondition.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build()}).build();
    private static final SdkField<List<String>> STRING_VALUE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StringValueList").getter(FilterCondition.getter(FilterCondition::stringValueList)).setter(FilterCondition.setter(Builder::stringValueList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValueList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, COMPARISON_OPERATOR_FIELD, STRING_VALUE_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String field;
    private final String comparisonOperator;
    private final List<String> stringValueList;

    private FilterCondition(BuilderImpl builder) {
        this.field = builder.field;
        this.comparisonOperator = builder.comparisonOperator;
        this.stringValueList = builder.stringValueList;
    }

    public FieldNameString field() {
        return FieldNameString.fromValue(this.field);
    }

    public String fieldAsString() {
        return this.field;
    }

    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public boolean hasStringValueList() {
        return this.stringValueList != null && !(this.stringValueList instanceof SdkAutoConstructList);
    }

    public List<String> stringValueList() {
        return this.stringValueList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValueList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterCondition)) {
            return false;
        }
        FilterCondition other = (FilterCondition)obj;
        return Objects.equals(this.fieldAsString(), other.fieldAsString()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.stringValueList(), other.stringValueList());
    }

    public String toString() {
        return ToString.builder((String)"FilterCondition").add("Field", (Object)this.fieldAsString()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("StringValueList", this.stringValueList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Field": {
                return Optional.ofNullable(clazz.cast(this.fieldAsString()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "StringValueList": {
                return Optional.ofNullable(clazz.cast(this.stringValueList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterCondition, T> g) {
        return obj -> g.apply((FilterCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String field;
        private String comparisonOperator;
        private List<String> stringValueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FilterCondition model) {
            this.field(model.field);
            this.comparisonOperator(model.comparisonOperator);
            this.stringValueList(model.stringValueList);
        }

        public final String getField() {
            return this.field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public final Builder field(FieldNameString field) {
            this.field(field == null ? null : field.toString());
            return this;
        }

        public final void setField(String field) {
            this.field = field;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Collection<String> getStringValueList() {
            return this.stringValueList;
        }

        @Override
        public final Builder stringValueList(Collection<String> stringValueList) {
            this.stringValueList = StringValueListCopier.copy(stringValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringValueList(String ... stringValueList) {
            this.stringValueList(Arrays.asList(stringValueList));
            return this;
        }

        public final void setStringValueList(Collection<String> stringValueList) {
            this.stringValueList = StringValueListCopier.copy(stringValueList);
        }

        public FilterCondition build() {
            return new FilterCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterCondition> {
        public Builder field(String var1);

        public Builder field(FieldNameString var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder stringValueList(Collection<String> var1);

        public Builder stringValueList(String ... var1);
    }
}

