/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.ResourceShareListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetailsMap
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetailsMap> {
    private static final SdkField<List<String>> RESOURCE_SHARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DetailsMap.getter(DetailsMap::resourceShare)).setter(DetailsMap.setter(Builder::resourceShare)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceShare").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> resourceShare;

    private DetailsMap(BuilderImpl builder) {
        this.resourceShare = builder.resourceShare;
    }

    public boolean hasResourceShare() {
        return this.resourceShare != null && !(this.resourceShare instanceof SdkAutoConstructList);
    }

    public List<String> resourceShare() {
        return this.resourceShare;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShare());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetailsMap)) {
            return false;
        }
        DetailsMap other = (DetailsMap)obj;
        return Objects.equals(this.resourceShare(), other.resourceShare());
    }

    public String toString() {
        return ToString.builder((String)"DetailsMap").add("ResourceShare", this.resourceShare()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceShare": {
                return Optional.ofNullable(clazz.cast(this.resourceShare()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetailsMap, T> g) {
        return obj -> g.apply((DetailsMap)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> resourceShare = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetailsMap model) {
            this.resourceShare(model.resourceShare);
        }

        public final Collection<String> getResourceShare() {
            return this.resourceShare;
        }

        @Override
        public final Builder resourceShare(Collection<String> resourceShare) {
            this.resourceShare = ResourceShareListCopier.copy(resourceShare);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceShare(String ... resourceShare) {
            this.resourceShare(Arrays.asList(resourceShare));
            return this;
        }

        public final void setResourceShare(Collection<String> resourceShare) {
            this.resourceShare = ResourceShareListCopier.copy(resourceShare);
        }

        public DetailsMap build() {
            return new DetailsMap(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetailsMap> {
        public Builder resourceShare(Collection<String> var1);

        public Builder resourceShare(String ... var1);
    }
}

