/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.ColumnNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnWildcard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnWildcard> {
    private static final SdkField<List<String>> EXCLUDED_COLUMN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ColumnWildcard.getter(ColumnWildcard::excludedColumnNames)).setter(ColumnWildcard.setter(Builder::excludedColumnNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedColumnNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUDED_COLUMN_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> excludedColumnNames;

    private ColumnWildcard(BuilderImpl builder) {
        this.excludedColumnNames = builder.excludedColumnNames;
    }

    public boolean hasExcludedColumnNames() {
        return this.excludedColumnNames != null && !(this.excludedColumnNames instanceof SdkAutoConstructList);
    }

    public List<String> excludedColumnNames() {
        return this.excludedColumnNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.excludedColumnNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnWildcard)) {
            return false;
        }
        ColumnWildcard other = (ColumnWildcard)obj;
        return Objects.equals(this.excludedColumnNames(), other.excludedColumnNames());
    }

    public String toString() {
        return ToString.builder((String)"ColumnWildcard").add("ExcludedColumnNames", this.excludedColumnNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExcludedColumnNames": {
                return Optional.ofNullable(clazz.cast(this.excludedColumnNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnWildcard, T> g) {
        return obj -> g.apply((ColumnWildcard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> excludedColumnNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnWildcard model) {
            this.excludedColumnNames(model.excludedColumnNames);
        }

        public final Collection<String> getExcludedColumnNames() {
            return this.excludedColumnNames;
        }

        @Override
        public final Builder excludedColumnNames(Collection<String> excludedColumnNames) {
            this.excludedColumnNames = ColumnNamesCopier.copy(excludedColumnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedColumnNames(String ... excludedColumnNames) {
            this.excludedColumnNames(Arrays.asList(excludedColumnNames));
            return this;
        }

        public final void setExcludedColumnNames(Collection<String> excludedColumnNames) {
            this.excludedColumnNames = ColumnNamesCopier.copy(excludedColumnNames);
        }

        public ColumnWildcard build() {
            return new ColumnWildcard(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnWildcard> {
        public Builder excludedColumnNames(Collection<String> var1);

        public Builder excludedColumnNames(String ... var1);
    }
}

