/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal;
import software.amazon.awssdk.services.lakeformation.model.Permission;
import software.amazon.awssdk.services.lakeformation.model.PermissionListCopier;
import software.amazon.awssdk.services.lakeformation.model.Resource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrincipalResourcePermissions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrincipalResourcePermissions> {
    private static final SdkField<DataLakePrincipal> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PrincipalResourcePermissions.getter(PrincipalResourcePermissions::principal)).setter(PrincipalResourcePermissions.setter(Builder::principal)).constructor(DataLakePrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()}).build();
    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PrincipalResourcePermissions.getter(PrincipalResourcePermissions::resource)).setter(PrincipalResourcePermissions.setter(Builder::resource)).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()}).build();
    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PrincipalResourcePermissions.getter(PrincipalResourcePermissions::permissionsAsStrings)).setter(PrincipalResourcePermissions.setter(Builder::permissionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PERMISSIONS_WITH_GRANT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PrincipalResourcePermissions.getter(PrincipalResourcePermissions::permissionsWithGrantOptionAsStrings)).setter(PrincipalResourcePermissions.setter(Builder::permissionsWithGrantOptionWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsWithGrantOption").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD, RESOURCE_FIELD, PERMISSIONS_FIELD, PERMISSIONS_WITH_GRANT_OPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final DataLakePrincipal principal;
    private final Resource resource;
    private final List<String> permissions;
    private final List<String> permissionsWithGrantOption;

    private PrincipalResourcePermissions(BuilderImpl builder) {
        this.principal = builder.principal;
        this.resource = builder.resource;
        this.permissions = builder.permissions;
        this.permissionsWithGrantOption = builder.permissionsWithGrantOption;
    }

    public DataLakePrincipal principal() {
        return this.principal;
    }

    public Resource resource() {
        return this.resource;
    }

    public List<Permission> permissions() {
        return PermissionListCopier.copyStringToEnum(this.permissions);
    }

    public boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public List<String> permissionsAsStrings() {
        return this.permissions;
    }

    public List<Permission> permissionsWithGrantOption() {
        return PermissionListCopier.copyStringToEnum(this.permissionsWithGrantOption);
    }

    public boolean hasPermissionsWithGrantOption() {
        return this.permissionsWithGrantOption != null && !(this.permissionsWithGrantOption instanceof SdkAutoConstructList);
    }

    public List<String> permissionsWithGrantOptionAsStrings() {
        return this.permissionsWithGrantOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsWithGrantOptionAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalResourcePermissions)) {
            return false;
        }
        PrincipalResourcePermissions other = (PrincipalResourcePermissions)obj;
        return Objects.equals(this.principal(), other.principal()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.permissionsAsStrings(), other.permissionsAsStrings()) && Objects.equals(this.permissionsWithGrantOptionAsStrings(), other.permissionsWithGrantOptionAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"PrincipalResourcePermissions").add("Principal", (Object)this.principal()).add("Resource", (Object)this.resource()).add("Permissions", this.permissionsAsStrings()).add("PermissionsWithGrantOption", this.permissionsWithGrantOptionAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "Resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissionsAsStrings()));
            }
            case "PermissionsWithGrantOption": {
                return Optional.ofNullable(clazz.cast(this.permissionsWithGrantOptionAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrincipalResourcePermissions, T> g) {
        return obj -> g.apply((PrincipalResourcePermissions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataLakePrincipal principal;
        private Resource resource;
        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();
        private List<String> permissionsWithGrantOption = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PrincipalResourcePermissions model) {
            this.principal(model.principal);
            this.resource(model.resource);
            this.permissionsWithStrings(model.permissions);
            this.permissionsWithGrantOptionWithStrings(model.permissionsWithGrantOption);
        }

        public final DataLakePrincipal.Builder getPrincipal() {
            return this.principal != null ? this.principal.toBuilder() : null;
        }

        @Override
        public final Builder principal(DataLakePrincipal principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(DataLakePrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        public final Resource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        public final Collection<String> getPermissions() {
            return this.permissions;
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String ... permissions) {
            this.permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionListCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        public final Collection<String> getPermissionsWithGrantOption() {
            return this.permissionsWithGrantOption;
        }

        @Override
        public final Builder permissionsWithGrantOptionWithStrings(Collection<String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copy(permissionsWithGrantOption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithGrantOptionWithStrings(String ... permissionsWithGrantOption) {
            this.permissionsWithGrantOptionWithStrings(Arrays.asList(permissionsWithGrantOption));
            return this;
        }

        @Override
        public final Builder permissionsWithGrantOption(Collection<Permission> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copyEnumToString(permissionsWithGrantOption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithGrantOption(Permission ... permissionsWithGrantOption) {
            this.permissionsWithGrantOption(Arrays.asList(permissionsWithGrantOption));
            return this;
        }

        public final void setPermissionsWithGrantOption(Collection<String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copy(permissionsWithGrantOption);
        }

        public PrincipalResourcePermissions build() {
            return new PrincipalResourcePermissions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrincipalResourcePermissions> {
        public Builder principal(DataLakePrincipal var1);

        default public Builder principal(Consumer<DataLakePrincipal.Builder> principal) {
            return this.principal((DataLakePrincipal)((DataLakePrincipal.Builder)DataLakePrincipal.builder().applyMutation(principal)).build());
        }

        public Builder resource(Resource var1);

        default public Builder resource(Consumer<Resource.Builder> resource) {
            return this.resource((Resource)((Resource.Builder)Resource.builder().applyMutation(resource)).build());
        }

        public Builder permissionsWithStrings(Collection<String> var1);

        public Builder permissionsWithStrings(String ... var1);

        public Builder permissions(Collection<Permission> var1);

        public Builder permissions(Permission ... var1);

        public Builder permissionsWithGrantOptionWithStrings(Collection<String> var1);

        public Builder permissionsWithGrantOptionWithStrings(String ... var1);

        public Builder permissionsWithGrantOption(Collection<Permission> var1);

        public Builder permissionsWithGrantOption(Permission ... var1);
    }
}

