/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.internal.UserAgentUtils;
import software.amazon.awssdk.services.kms.model.ListKeyRotationsRequest;
import software.amazon.awssdk.services.kms.model.ListKeyRotationsResponse;
import software.amazon.awssdk.services.kms.model.RotationsListEntry;

public class ListKeyRotationsPublisher
implements SdkPublisher<ListKeyRotationsResponse> {
    private final KmsAsyncClient client;
    private final ListKeyRotationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKeyRotationsPublisher(KmsAsyncClient client, ListKeyRotationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKeyRotationsPublisher(KmsAsyncClient client, ListKeyRotationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKeyRotationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKeyRotationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RotationsListEntry> rotations() {
        return this.flatMapIterable(response -> response.rotations());
    }

    private class ListKeyRotationsResponseFetcher
    implements AsyncPageFetcher<ListKeyRotationsResponse> {
        private ListKeyRotationsResponseFetcher() {
        }

        public boolean hasNextPage(ListKeyRotationsResponse previousPage) {
            return previousPage.truncated() != null && previousPage.truncated() != false;
        }

        public CompletableFuture<ListKeyRotationsResponse> nextPage(ListKeyRotationsResponse previousPage) {
            if (previousPage == null) {
                return ListKeyRotationsPublisher.this.client.listKeyRotations(ListKeyRotationsPublisher.this.firstRequest);
            }
            return ListKeyRotationsPublisher.this.client.listKeyRotations((ListKeyRotationsRequest)((Object)ListKeyRotationsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

