/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyListEntry> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(KeyListEntry.getter(KeyListEntry::keyId)).setter(KeyListEntry.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyArn").getter(KeyListEntry.getter(KeyListEntry::keyArn)).setter(KeyListEntry.setter(Builder::keyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KeyId", KEY_ID_FIELD);
            this.put("KeyArn", KEY_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String keyId;
    private final String keyArn;

    private KeyListEntry(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.keyArn = builder.keyArn;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final String keyArn() {
        return this.keyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyListEntry)) {
            return false;
        }
        KeyListEntry other = (KeyListEntry)obj;
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.keyArn(), other.keyArn());
    }

    public final String toString() {
        return ToString.builder((String)"KeyListEntry").add("KeyId", (Object)this.keyId()).add("KeyArn", (Object)this.keyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "KeyArn": {
                return Optional.ofNullable(clazz.cast(this.keyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KeyListEntry, T> g) {
        return obj -> g.apply((KeyListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyId;
        private String keyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyListEntry model) {
            this.keyId(model.keyId);
            this.keyArn(model.keyArn);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getKeyArn() {
            return this.keyArn;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public KeyListEntry build() {
            return new KeyListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyListEntry> {
        public Builder keyId(String var1);

        public Builder keyArn(String var1);
    }
}

