/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KeyAgreementAlgorithmSpec;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.services.kms.model.OriginType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeriveSharedSecretResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, DeriveSharedSecretResponse> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(DeriveSharedSecretResponse.getter(DeriveSharedSecretResponse::keyId)).setter(DeriveSharedSecretResponse.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<SdkBytes> SHARED_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("SharedSecret").getter(DeriveSharedSecretResponse.getter(DeriveSharedSecretResponse::sharedSecret)).setter(DeriveSharedSecretResponse.setter(Builder::sharedSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedSecret").build()}).build();
    private static final SdkField<SdkBytes> CIPHERTEXT_FOR_RECIPIENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("CiphertextForRecipient").getter(DeriveSharedSecretResponse.getter(DeriveSharedSecretResponse::ciphertextForRecipient)).setter(DeriveSharedSecretResponse.setter(Builder::ciphertextForRecipient)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CiphertextForRecipient").build()}).build();
    private static final SdkField<String> KEY_AGREEMENT_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyAgreementAlgorithm").getter(DeriveSharedSecretResponse.getter(DeriveSharedSecretResponse::keyAgreementAlgorithmAsString)).setter(DeriveSharedSecretResponse.setter(Builder::keyAgreementAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAgreementAlgorithm").build()}).build();
    private static final SdkField<String> KEY_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyOrigin").getter(DeriveSharedSecretResponse.getter(DeriveSharedSecretResponse::keyOriginAsString)).setter(DeriveSharedSecretResponse.setter(Builder::keyOrigin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyOrigin").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, SHARED_SECRET_FIELD, CIPHERTEXT_FOR_RECIPIENT_FIELD, KEY_AGREEMENT_ALGORITHM_FIELD, KEY_ORIGIN_FIELD));
    private final String keyId;
    private final SdkBytes sharedSecret;
    private final SdkBytes ciphertextForRecipient;
    private final String keyAgreementAlgorithm;
    private final String keyOrigin;

    private DeriveSharedSecretResponse(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.sharedSecret = builder.sharedSecret;
        this.ciphertextForRecipient = builder.ciphertextForRecipient;
        this.keyAgreementAlgorithm = builder.keyAgreementAlgorithm;
        this.keyOrigin = builder.keyOrigin;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final SdkBytes sharedSecret() {
        return this.sharedSecret;
    }

    public final SdkBytes ciphertextForRecipient() {
        return this.ciphertextForRecipient;
    }

    public final KeyAgreementAlgorithmSpec keyAgreementAlgorithm() {
        return KeyAgreementAlgorithmSpec.fromValue(this.keyAgreementAlgorithm);
    }

    public final String keyAgreementAlgorithmAsString() {
        return this.keyAgreementAlgorithm;
    }

    public final OriginType keyOrigin() {
        return OriginType.fromValue(this.keyOrigin);
    }

    public final String keyOriginAsString() {
        return this.keyOrigin;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.ciphertextForRecipient());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAgreementAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyOriginAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeriveSharedSecretResponse)) {
            return false;
        }
        DeriveSharedSecretResponse other = (DeriveSharedSecretResponse)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.sharedSecret(), other.sharedSecret()) && Objects.equals(this.ciphertextForRecipient(), other.ciphertextForRecipient()) && Objects.equals(this.keyAgreementAlgorithmAsString(), other.keyAgreementAlgorithmAsString()) && Objects.equals(this.keyOriginAsString(), other.keyOriginAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeriveSharedSecretResponse").add("KeyId", (Object)this.keyId()).add("SharedSecret", (Object)(this.sharedSecret() == null ? null : "*** Sensitive Data Redacted ***")).add("CiphertextForRecipient", (Object)this.ciphertextForRecipient()).add("KeyAgreementAlgorithm", (Object)this.keyAgreementAlgorithmAsString()).add("KeyOrigin", (Object)this.keyOriginAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "SharedSecret": {
                return Optional.ofNullable(clazz.cast(this.sharedSecret()));
            }
            case "CiphertextForRecipient": {
                return Optional.ofNullable(clazz.cast(this.ciphertextForRecipient()));
            }
            case "KeyAgreementAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyAgreementAlgorithmAsString()));
            }
            case "KeyOrigin": {
                return Optional.ofNullable(clazz.cast(this.keyOriginAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeriveSharedSecretResponse, T> g) {
        return obj -> g.apply((DeriveSharedSecretResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private String keyId;
        private SdkBytes sharedSecret;
        private SdkBytes ciphertextForRecipient;
        private String keyAgreementAlgorithm;
        private String keyOrigin;

        private BuilderImpl() {
        }

        private BuilderImpl(DeriveSharedSecretResponse model) {
            super(model);
            this.keyId(model.keyId);
            this.sharedSecret(model.sharedSecret);
            this.ciphertextForRecipient(model.ciphertextForRecipient);
            this.keyAgreementAlgorithm(model.keyAgreementAlgorithm);
            this.keyOrigin(model.keyOrigin);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final ByteBuffer getSharedSecret() {
            return this.sharedSecret == null ? null : this.sharedSecret.asByteBuffer();
        }

        public final void setSharedSecret(ByteBuffer sharedSecret) {
            this.sharedSecret(sharedSecret == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)sharedSecret));
        }

        @Override
        public final Builder sharedSecret(SdkBytes sharedSecret) {
            this.sharedSecret = sharedSecret;
            return this;
        }

        public final ByteBuffer getCiphertextForRecipient() {
            return this.ciphertextForRecipient == null ? null : this.ciphertextForRecipient.asByteBuffer();
        }

        public final void setCiphertextForRecipient(ByteBuffer ciphertextForRecipient) {
            this.ciphertextForRecipient(ciphertextForRecipient == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)ciphertextForRecipient));
        }

        @Override
        public final Builder ciphertextForRecipient(SdkBytes ciphertextForRecipient) {
            this.ciphertextForRecipient = ciphertextForRecipient;
            return this;
        }

        public final String getKeyAgreementAlgorithm() {
            return this.keyAgreementAlgorithm;
        }

        public final void setKeyAgreementAlgorithm(String keyAgreementAlgorithm) {
            this.keyAgreementAlgorithm = keyAgreementAlgorithm;
        }

        @Override
        public final Builder keyAgreementAlgorithm(String keyAgreementAlgorithm) {
            this.keyAgreementAlgorithm = keyAgreementAlgorithm;
            return this;
        }

        @Override
        public final Builder keyAgreementAlgorithm(KeyAgreementAlgorithmSpec keyAgreementAlgorithm) {
            this.keyAgreementAlgorithm(keyAgreementAlgorithm == null ? null : keyAgreementAlgorithm.toString());
            return this;
        }

        public final String getKeyOrigin() {
            return this.keyOrigin;
        }

        public final void setKeyOrigin(String keyOrigin) {
            this.keyOrigin = keyOrigin;
        }

        @Override
        public final Builder keyOrigin(String keyOrigin) {
            this.keyOrigin = keyOrigin;
            return this;
        }

        @Override
        public final Builder keyOrigin(OriginType keyOrigin) {
            this.keyOrigin(keyOrigin == null ? null : keyOrigin.toString());
            return this;
        }

        @Override
        public DeriveSharedSecretResponse build() {
            return new DeriveSharedSecretResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeriveSharedSecretResponse> {
        public Builder keyId(String var1);

        public Builder sharedSecret(SdkBytes var1);

        public Builder ciphertextForRecipient(SdkBytes var1);

        public Builder keyAgreementAlgorithm(String var1);

        public Builder keyAgreementAlgorithm(KeyAgreementAlgorithmSpec var1);

        public Builder keyOrigin(String var1);

        public Builder keyOrigin(OriginType var1);
    }
}

