/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.internal.UserAgentUtils;
import software.amazon.awssdk.services.kms.model.ListResourceTagsRequest;
import software.amazon.awssdk.services.kms.model.ListResourceTagsResponse;
import software.amazon.awssdk.services.kms.model.Tag;

public class ListResourceTagsIterable
implements SdkIterable<ListResourceTagsResponse> {
    private final KmsClient client;
    private final ListResourceTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceTagsIterable(KmsClient client, ListResourceTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceTagsResponseFetcher();
    }

    public Iterator<ListResourceTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Tag> tags() {
        Function<ListResourceTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceTagsResponseFetcher
    implements SyncPageFetcher<ListResourceTagsResponse> {
        private ListResourceTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceTagsResponse previousPage) {
            return previousPage.truncated();
        }

        public ListResourceTagsResponse nextPage(ListResourceTagsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceTagsIterable.this.client.listResourceTags(ListResourceTagsIterable.this.firstRequest);
            }
            return ListResourceTagsIterable.this.client.listResourceTags((ListResourceTagsRequest)((Object)ListResourceTagsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

