/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.services.kms.model.Tag;
import software.amazon.awssdk.services.kms.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicateKeyRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, ReplicateKeyRequest> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(ReplicateKeyRequest.getter(ReplicateKeyRequest::keyId)).setter(ReplicateKeyRequest.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> REPLICA_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaRegion").getter(ReplicateKeyRequest.getter(ReplicateKeyRequest::replicaRegion)).setter(ReplicateKeyRequest.setter(Builder::replicaRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaRegion").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Policy").getter(ReplicateKeyRequest.getter(ReplicateKeyRequest::policy)).setter(ReplicateKeyRequest.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()}).build();
    private static final SdkField<Boolean> BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BypassPolicyLockoutSafetyCheck").getter(ReplicateKeyRequest.getter(ReplicateKeyRequest::bypassPolicyLockoutSafetyCheck)).setter(ReplicateKeyRequest.setter(Builder::bypassPolicyLockoutSafetyCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BypassPolicyLockoutSafetyCheck").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ReplicateKeyRequest.getter(ReplicateKeyRequest::description)).setter(ReplicateKeyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ReplicateKeyRequest.getter(ReplicateKeyRequest::tags)).setter(ReplicateKeyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, REPLICA_REGION_FIELD, POLICY_FIELD, BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private final String keyId;
    private final String replicaRegion;
    private final String policy;
    private final Boolean bypassPolicyLockoutSafetyCheck;
    private final String description;
    private final List<Tag> tags;

    private ReplicateKeyRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.replicaRegion = builder.replicaRegion;
        this.policy = builder.policy;
        this.bypassPolicyLockoutSafetyCheck = builder.bypassPolicyLockoutSafetyCheck;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final String replicaRegion() {
        return this.replicaRegion;
    }

    public final String policy() {
        return this.policy;
    }

    public final Boolean bypassPolicyLockoutSafetyCheck() {
        return this.bypassPolicyLockoutSafetyCheck;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.bypassPolicyLockoutSafetyCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicateKeyRequest)) {
            return false;
        }
        ReplicateKeyRequest other = (ReplicateKeyRequest)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.replicaRegion(), other.replicaRegion()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.bypassPolicyLockoutSafetyCheck(), other.bypassPolicyLockoutSafetyCheck()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicateKeyRequest").add("KeyId", (Object)this.keyId()).add("ReplicaRegion", (Object)this.replicaRegion()).add("Policy", (Object)this.policy()).add("BypassPolicyLockoutSafetyCheck", (Object)this.bypassPolicyLockoutSafetyCheck()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "ReplicaRegion": {
                return Optional.ofNullable(clazz.cast(this.replicaRegion()));
            }
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "BypassPolicyLockoutSafetyCheck": {
                return Optional.ofNullable(clazz.cast(this.bypassPolicyLockoutSafetyCheck()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicateKeyRequest, T> g) {
        return obj -> g.apply((ReplicateKeyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String keyId;
        private String replicaRegion;
        private String policy;
        private Boolean bypassPolicyLockoutSafetyCheck;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicateKeyRequest model) {
            super(model);
            this.keyId(model.keyId);
            this.replicaRegion(model.replicaRegion);
            this.policy(model.policy);
            this.bypassPolicyLockoutSafetyCheck(model.bypassPolicyLockoutSafetyCheck);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        @Transient
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getReplicaRegion() {
            return this.replicaRegion;
        }

        public final void setReplicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
        }

        @Override
        @Transient
        public final Builder replicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
            return this;
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        @Transient
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final Boolean getBypassPolicyLockoutSafetyCheck() {
            return this.bypassPolicyLockoutSafetyCheck;
        }

        public final void setBypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
        }

        @Override
        @Transient
        public final Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReplicateKeyRequest build() {
            return new ReplicateKeyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReplicateKeyRequest> {
        public Builder keyId(String var1);

        public Builder replicaRegion(String var1);

        public Builder policy(String var1);

        public Builder bypassPolicyLockoutSafetyCheck(Boolean var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

