/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec;
import software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec;
import software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpecListCopier;
import software.amazon.awssdk.services.kms.model.KeyUsageType;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec;
import software.amazon.awssdk.services.kms.model.SigningAlgorithmSpecListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPublicKeyResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, GetPublicKeyResponse> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(GetPublicKeyResponse.getter(GetPublicKeyResponse::keyId)).setter(GetPublicKeyResponse.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<SdkBytes> PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("PublicKey").getter(GetPublicKeyResponse.getter(GetPublicKeyResponse::publicKey)).setter(GetPublicKeyResponse.setter(Builder::publicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()}).build();
    private static final SdkField<String> CUSTOMER_MASTER_KEY_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerMasterKeySpec").getter(GetPublicKeyResponse.getter(GetPublicKeyResponse::customerMasterKeySpecAsString)).setter(GetPublicKeyResponse.setter(Builder::customerMasterKeySpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerMasterKeySpec").build()}).build();
    private static final SdkField<String> KEY_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyUsage").getter(GetPublicKeyResponse.getter(GetPublicKeyResponse::keyUsageAsString)).setter(GetPublicKeyResponse.setter(Builder::keyUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyUsage").build()}).build();
    private static final SdkField<List<String>> ENCRYPTION_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EncryptionAlgorithms").getter(GetPublicKeyResponse.getter(GetPublicKeyResponse::encryptionAlgorithmsAsStrings)).setter(GetPublicKeyResponse.setter(Builder::encryptionAlgorithmsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAlgorithms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SIGNING_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SigningAlgorithms").getter(GetPublicKeyResponse.getter(GetPublicKeyResponse::signingAlgorithmsAsStrings)).setter(GetPublicKeyResponse.setter(Builder::signingAlgorithmsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, PUBLIC_KEY_FIELD, CUSTOMER_MASTER_KEY_SPEC_FIELD, KEY_USAGE_FIELD, ENCRYPTION_ALGORITHMS_FIELD, SIGNING_ALGORITHMS_FIELD));
    private final String keyId;
    private final SdkBytes publicKey;
    private final String customerMasterKeySpec;
    private final String keyUsage;
    private final List<String> encryptionAlgorithms;
    private final List<String> signingAlgorithms;

    private GetPublicKeyResponse(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.publicKey = builder.publicKey;
        this.customerMasterKeySpec = builder.customerMasterKeySpec;
        this.keyUsage = builder.keyUsage;
        this.encryptionAlgorithms = builder.encryptionAlgorithms;
        this.signingAlgorithms = builder.signingAlgorithms;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final SdkBytes publicKey() {
        return this.publicKey;
    }

    public final CustomerMasterKeySpec customerMasterKeySpec() {
        return CustomerMasterKeySpec.fromValue(this.customerMasterKeySpec);
    }

    public final String customerMasterKeySpecAsString() {
        return this.customerMasterKeySpec;
    }

    public final KeyUsageType keyUsage() {
        return KeyUsageType.fromValue(this.keyUsage);
    }

    public final String keyUsageAsString() {
        return this.keyUsage;
    }

    public final List<EncryptionAlgorithmSpec> encryptionAlgorithms() {
        return EncryptionAlgorithmSpecListCopier.copyStringToEnum(this.encryptionAlgorithms);
    }

    public final boolean hasEncryptionAlgorithms() {
        return this.encryptionAlgorithms != null && !(this.encryptionAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<String> encryptionAlgorithmsAsStrings() {
        return this.encryptionAlgorithms;
    }

    public final List<SigningAlgorithmSpec> signingAlgorithms() {
        return SigningAlgorithmSpecListCopier.copyStringToEnum(this.signingAlgorithms);
    }

    public final boolean hasSigningAlgorithms() {
        return this.signingAlgorithms != null && !(this.signingAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<String> signingAlgorithmsAsStrings() {
        return this.signingAlgorithms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerMasterKeySpecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyUsageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEncryptionAlgorithms() ? this.encryptionAlgorithmsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSigningAlgorithms() ? this.signingAlgorithmsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPublicKeyResponse)) {
            return false;
        }
        GetPublicKeyResponse other = (GetPublicKeyResponse)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.publicKey(), other.publicKey()) && Objects.equals(this.customerMasterKeySpecAsString(), other.customerMasterKeySpecAsString()) && Objects.equals(this.keyUsageAsString(), other.keyUsageAsString()) && this.hasEncryptionAlgorithms() == other.hasEncryptionAlgorithms() && Objects.equals(this.encryptionAlgorithmsAsStrings(), other.encryptionAlgorithmsAsStrings()) && this.hasSigningAlgorithms() == other.hasSigningAlgorithms() && Objects.equals(this.signingAlgorithmsAsStrings(), other.signingAlgorithmsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetPublicKeyResponse").add("KeyId", (Object)this.keyId()).add("PublicKey", (Object)this.publicKey()).add("CustomerMasterKeySpec", (Object)this.customerMasterKeySpecAsString()).add("KeyUsage", (Object)this.keyUsageAsString()).add("EncryptionAlgorithms", this.hasEncryptionAlgorithms() ? this.encryptionAlgorithmsAsStrings() : null).add("SigningAlgorithms", this.hasSigningAlgorithms() ? this.signingAlgorithmsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "PublicKey": {
                return Optional.ofNullable(clazz.cast(this.publicKey()));
            }
            case "CustomerMasterKeySpec": {
                return Optional.ofNullable(clazz.cast(this.customerMasterKeySpecAsString()));
            }
            case "KeyUsage": {
                return Optional.ofNullable(clazz.cast(this.keyUsageAsString()));
            }
            case "EncryptionAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.encryptionAlgorithmsAsStrings()));
            }
            case "SigningAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.signingAlgorithmsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPublicKeyResponse, T> g) {
        return obj -> g.apply((GetPublicKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private String keyId;
        private SdkBytes publicKey;
        private String customerMasterKeySpec;
        private String keyUsage;
        private List<String> encryptionAlgorithms = DefaultSdkAutoConstructList.getInstance();
        private List<String> signingAlgorithms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPublicKeyResponse model) {
            super(model);
            this.keyId(model.keyId);
            this.publicKey(model.publicKey);
            this.customerMasterKeySpec(model.customerMasterKeySpec);
            this.keyUsage(model.keyUsage);
            this.encryptionAlgorithmsWithStrings(model.encryptionAlgorithms);
            this.signingAlgorithmsWithStrings(model.signingAlgorithms);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final ByteBuffer getPublicKey() {
            return this.publicKey == null ? null : this.publicKey.asByteBuffer();
        }

        @Override
        public final Builder publicKey(SdkBytes publicKey) {
            this.publicKey = StandardMemberCopier.copy((SdkBytes)publicKey);
            return this;
        }

        public final void setPublicKey(ByteBuffer publicKey) {
            this.publicKey(publicKey == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)publicKey));
        }

        public final String getCustomerMasterKeySpec() {
            return this.customerMasterKeySpec;
        }

        @Override
        public final Builder customerMasterKeySpec(String customerMasterKeySpec) {
            this.customerMasterKeySpec = customerMasterKeySpec;
            return this;
        }

        @Override
        public final Builder customerMasterKeySpec(CustomerMasterKeySpec customerMasterKeySpec) {
            this.customerMasterKeySpec(customerMasterKeySpec == null ? null : customerMasterKeySpec.toString());
            return this;
        }

        public final void setCustomerMasterKeySpec(String customerMasterKeySpec) {
            this.customerMasterKeySpec = customerMasterKeySpec;
        }

        public final String getKeyUsage() {
            return this.keyUsage;
        }

        @Override
        public final Builder keyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        @Override
        public final Builder keyUsage(KeyUsageType keyUsage) {
            this.keyUsage(keyUsage == null ? null : keyUsage.toString());
            return this;
        }

        public final void setKeyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
        }

        public final Collection<String> getEncryptionAlgorithms() {
            if (this.encryptionAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.encryptionAlgorithms;
        }

        @Override
        public final Builder encryptionAlgorithmsWithStrings(Collection<String> encryptionAlgorithms) {
            this.encryptionAlgorithms = EncryptionAlgorithmSpecListCopier.copy(encryptionAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionAlgorithmsWithStrings(String ... encryptionAlgorithms) {
            this.encryptionAlgorithmsWithStrings(Arrays.asList(encryptionAlgorithms));
            return this;
        }

        @Override
        public final Builder encryptionAlgorithms(Collection<EncryptionAlgorithmSpec> encryptionAlgorithms) {
            this.encryptionAlgorithms = EncryptionAlgorithmSpecListCopier.copyEnumToString(encryptionAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionAlgorithms(EncryptionAlgorithmSpec ... encryptionAlgorithms) {
            this.encryptionAlgorithms(Arrays.asList(encryptionAlgorithms));
            return this;
        }

        public final void setEncryptionAlgorithms(Collection<String> encryptionAlgorithms) {
            this.encryptionAlgorithms = EncryptionAlgorithmSpecListCopier.copy(encryptionAlgorithms);
        }

        public final Collection<String> getSigningAlgorithms() {
            if (this.signingAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.signingAlgorithms;
        }

        @Override
        public final Builder signingAlgorithmsWithStrings(Collection<String> signingAlgorithms) {
            this.signingAlgorithms = SigningAlgorithmSpecListCopier.copy(signingAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signingAlgorithmsWithStrings(String ... signingAlgorithms) {
            this.signingAlgorithmsWithStrings(Arrays.asList(signingAlgorithms));
            return this;
        }

        @Override
        public final Builder signingAlgorithms(Collection<SigningAlgorithmSpec> signingAlgorithms) {
            this.signingAlgorithms = SigningAlgorithmSpecListCopier.copyEnumToString(signingAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signingAlgorithms(SigningAlgorithmSpec ... signingAlgorithms) {
            this.signingAlgorithms(Arrays.asList(signingAlgorithms));
            return this;
        }

        public final void setSigningAlgorithms(Collection<String> signingAlgorithms) {
            this.signingAlgorithms = SigningAlgorithmSpecListCopier.copy(signingAlgorithms);
        }

        @Override
        public GetPublicKeyResponse build() {
            return new GetPublicKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPublicKeyResponse> {
        public Builder keyId(String var1);

        public Builder publicKey(SdkBytes var1);

        public Builder customerMasterKeySpec(String var1);

        public Builder customerMasterKeySpec(CustomerMasterKeySpec var1);

        public Builder keyUsage(String var1);

        public Builder keyUsage(KeyUsageType var1);

        public Builder encryptionAlgorithmsWithStrings(Collection<String> var1);

        public Builder encryptionAlgorithmsWithStrings(String ... var1);

        public Builder encryptionAlgorithms(Collection<EncryptionAlgorithmSpec> var1);

        public Builder encryptionAlgorithms(EncryptionAlgorithmSpec ... var1);

        public Builder signingAlgorithmsWithStrings(Collection<String> var1);

        public Builder signingAlgorithmsWithStrings(String ... var1);

        public Builder signingAlgorithms(Collection<SigningAlgorithmSpec> var1);

        public Builder signingAlgorithms(SigningAlgorithmSpec ... var1);
    }
}

