/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AliasListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AliasListEntry> {
    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AliasName").getter(AliasListEntry.getter(AliasListEntry::aliasName)).setter(AliasListEntry.setter(Builder::aliasName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasName").build()}).build();
    private static final SdkField<String> ALIAS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AliasArn").getter(AliasListEntry.getter(AliasListEntry::aliasArn)).setter(AliasListEntry.setter(Builder::aliasArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasArn").build()}).build();
    private static final SdkField<String> TARGET_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetKeyId").getter(AliasListEntry.getter(AliasListEntry::targetKeyId)).setter(AliasListEntry.setter(Builder::targetKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_NAME_FIELD, ALIAS_ARN_FIELD, TARGET_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String aliasName;
    private final String aliasArn;
    private final String targetKeyId;

    private AliasListEntry(BuilderImpl builder) {
        this.aliasName = builder.aliasName;
        this.aliasArn = builder.aliasArn;
        this.targetKeyId = builder.targetKeyId;
    }

    public String aliasName() {
        return this.aliasName;
    }

    public String aliasArn() {
        return this.aliasArn;
    }

    public String targetKeyId() {
        return this.targetKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasListEntry)) {
            return false;
        }
        AliasListEntry other = (AliasListEntry)obj;
        return Objects.equals(this.aliasName(), other.aliasName()) && Objects.equals(this.aliasArn(), other.aliasArn()) && Objects.equals(this.targetKeyId(), other.targetKeyId());
    }

    public String toString() {
        return ToString.builder((String)"AliasListEntry").add("AliasName", (Object)this.aliasName()).add("AliasArn", (Object)this.aliasArn()).add("TargetKeyId", (Object)this.targetKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AliasName": {
                return Optional.ofNullable(clazz.cast(this.aliasName()));
            }
            case "AliasArn": {
                return Optional.ofNullable(clazz.cast(this.aliasArn()));
            }
            case "TargetKeyId": {
                return Optional.ofNullable(clazz.cast(this.targetKeyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AliasListEntry, T> g) {
        return obj -> g.apply((AliasListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aliasName;
        private String aliasArn;
        private String targetKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(AliasListEntry model) {
            this.aliasName(model.aliasName);
            this.aliasArn(model.aliasArn);
            this.targetKeyId(model.targetKeyId);
        }

        public final String getAliasName() {
            return this.aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public final String getAliasArn() {
            return this.aliasArn;
        }

        @Override
        public final Builder aliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
            return this;
        }

        public final void setAliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
        }

        public final String getTargetKeyId() {
            return this.targetKeyId;
        }

        @Override
        public final Builder targetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
            return this;
        }

        public final void setTargetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
        }

        public AliasListEntry build() {
            return new AliasListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AliasListEntry> {
        public Builder aliasName(String var1);

        public Builder aliasArn(String var1);

        public Builder targetKeyId(String var1);
    }
}

