/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec;
import software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec;
import software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpecListCopier;
import software.amazon.awssdk.services.kms.model.ExpirationModelType;
import software.amazon.awssdk.services.kms.model.KeyManagerType;
import software.amazon.awssdk.services.kms.model.KeyState;
import software.amazon.awssdk.services.kms.model.KeyUsageType;
import software.amazon.awssdk.services.kms.model.OriginType;
import software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec;
import software.amazon.awssdk.services.kms.model.SigningAlgorithmSpecListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyMetadata> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AWSAccountId").getter(KeyMetadata.getter(KeyMetadata::awsAccountId)).setter(KeyMetadata.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSAccountId").build()}).build();
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(KeyMetadata.getter(KeyMetadata::keyId)).setter(KeyMetadata.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(KeyMetadata.getter(KeyMetadata::arn)).setter(KeyMetadata.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(KeyMetadata.getter(KeyMetadata::creationDate)).setter(KeyMetadata.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(KeyMetadata.getter(KeyMetadata::enabled)).setter(KeyMetadata.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(KeyMetadata.getter(KeyMetadata::description)).setter(KeyMetadata.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> KEY_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyUsage").getter(KeyMetadata.getter(KeyMetadata::keyUsageAsString)).setter(KeyMetadata.setter(Builder::keyUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyUsage").build()}).build();
    private static final SdkField<String> KEY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyState").getter(KeyMetadata.getter(KeyMetadata::keyStateAsString)).setter(KeyMetadata.setter(Builder::keyState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyState").build()}).build();
    private static final SdkField<Instant> DELETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeletionDate").getter(KeyMetadata.getter(KeyMetadata::deletionDate)).setter(KeyMetadata.setter(Builder::deletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionDate").build()}).build();
    private static final SdkField<Instant> VALID_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ValidTo").getter(KeyMetadata.getter(KeyMetadata::validTo)).setter(KeyMetadata.setter(Builder::validTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidTo").build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Origin").getter(KeyMetadata.getter(KeyMetadata::originAsString)).setter(KeyMetadata.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()}).build();
    private static final SdkField<String> CUSTOM_KEY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomKeyStoreId").getter(KeyMetadata.getter(KeyMetadata::customKeyStoreId)).setter(KeyMetadata.setter(Builder::customKeyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKeyStoreId").build()}).build();
    private static final SdkField<String> CLOUD_HSM_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudHsmClusterId").getter(KeyMetadata.getter(KeyMetadata::cloudHsmClusterId)).setter(KeyMetadata.setter(Builder::cloudHsmClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudHsmClusterId").build()}).build();
    private static final SdkField<String> EXPIRATION_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpirationModel").getter(KeyMetadata.getter(KeyMetadata::expirationModelAsString)).setter(KeyMetadata.setter(Builder::expirationModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationModel").build()}).build();
    private static final SdkField<String> KEY_MANAGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyManager").getter(KeyMetadata.getter(KeyMetadata::keyManagerAsString)).setter(KeyMetadata.setter(Builder::keyManager)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyManager").build()}).build();
    private static final SdkField<String> CUSTOMER_MASTER_KEY_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerMasterKeySpec").getter(KeyMetadata.getter(KeyMetadata::customerMasterKeySpecAsString)).setter(KeyMetadata.setter(Builder::customerMasterKeySpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerMasterKeySpec").build()}).build();
    private static final SdkField<List<String>> ENCRYPTION_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EncryptionAlgorithms").getter(KeyMetadata.getter(KeyMetadata::encryptionAlgorithmsAsStrings)).setter(KeyMetadata.setter(Builder::encryptionAlgorithmsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAlgorithms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SIGNING_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SigningAlgorithms").getter(KeyMetadata.getter(KeyMetadata::signingAlgorithmsAsStrings)).setter(KeyMetadata.setter(Builder::signingAlgorithmsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, KEY_ID_FIELD, ARN_FIELD, CREATION_DATE_FIELD, ENABLED_FIELD, DESCRIPTION_FIELD, KEY_USAGE_FIELD, KEY_STATE_FIELD, DELETION_DATE_FIELD, VALID_TO_FIELD, ORIGIN_FIELD, CUSTOM_KEY_STORE_ID_FIELD, CLOUD_HSM_CLUSTER_ID_FIELD, EXPIRATION_MODEL_FIELD, KEY_MANAGER_FIELD, CUSTOMER_MASTER_KEY_SPEC_FIELD, ENCRYPTION_ALGORITHMS_FIELD, SIGNING_ALGORITHMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String awsAccountId;
    private final String keyId;
    private final String arn;
    private final Instant creationDate;
    private final Boolean enabled;
    private final String description;
    private final String keyUsage;
    private final String keyState;
    private final Instant deletionDate;
    private final Instant validTo;
    private final String origin;
    private final String customKeyStoreId;
    private final String cloudHsmClusterId;
    private final String expirationModel;
    private final String keyManager;
    private final String customerMasterKeySpec;
    private final List<String> encryptionAlgorithms;
    private final List<String> signingAlgorithms;

    private KeyMetadata(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.keyId = builder.keyId;
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.enabled = builder.enabled;
        this.description = builder.description;
        this.keyUsage = builder.keyUsage;
        this.keyState = builder.keyState;
        this.deletionDate = builder.deletionDate;
        this.validTo = builder.validTo;
        this.origin = builder.origin;
        this.customKeyStoreId = builder.customKeyStoreId;
        this.cloudHsmClusterId = builder.cloudHsmClusterId;
        this.expirationModel = builder.expirationModel;
        this.keyManager = builder.keyManager;
        this.customerMasterKeySpec = builder.customerMasterKeySpec;
        this.encryptionAlgorithms = builder.encryptionAlgorithms;
        this.signingAlgorithms = builder.signingAlgorithms;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public String keyId() {
        return this.keyId;
    }

    public String arn() {
        return this.arn;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String description() {
        return this.description;
    }

    public KeyUsageType keyUsage() {
        return KeyUsageType.fromValue(this.keyUsage);
    }

    public String keyUsageAsString() {
        return this.keyUsage;
    }

    public KeyState keyState() {
        return KeyState.fromValue(this.keyState);
    }

    public String keyStateAsString() {
        return this.keyState;
    }

    public Instant deletionDate() {
        return this.deletionDate;
    }

    public Instant validTo() {
        return this.validTo;
    }

    public OriginType origin() {
        return OriginType.fromValue(this.origin);
    }

    public String originAsString() {
        return this.origin;
    }

    public String customKeyStoreId() {
        return this.customKeyStoreId;
    }

    public String cloudHsmClusterId() {
        return this.cloudHsmClusterId;
    }

    public ExpirationModelType expirationModel() {
        return ExpirationModelType.fromValue(this.expirationModel);
    }

    public String expirationModelAsString() {
        return this.expirationModel;
    }

    public KeyManagerType keyManager() {
        return KeyManagerType.fromValue(this.keyManager);
    }

    public String keyManagerAsString() {
        return this.keyManager;
    }

    public CustomerMasterKeySpec customerMasterKeySpec() {
        return CustomerMasterKeySpec.fromValue(this.customerMasterKeySpec);
    }

    public String customerMasterKeySpecAsString() {
        return this.customerMasterKeySpec;
    }

    public List<EncryptionAlgorithmSpec> encryptionAlgorithms() {
        return EncryptionAlgorithmSpecListCopier.copyStringToEnum(this.encryptionAlgorithms);
    }

    public boolean hasEncryptionAlgorithms() {
        return this.encryptionAlgorithms != null && !(this.encryptionAlgorithms instanceof SdkAutoConstructList);
    }

    public List<String> encryptionAlgorithmsAsStrings() {
        return this.encryptionAlgorithms;
    }

    public List<SigningAlgorithmSpec> signingAlgorithms() {
        return SigningAlgorithmSpecListCopier.copyStringToEnum(this.signingAlgorithms);
    }

    public boolean hasSigningAlgorithms() {
        return this.signingAlgorithms != null && !(this.signingAlgorithms instanceof SdkAutoConstructList);
    }

    public List<String> signingAlgorithmsAsStrings() {
        return this.signingAlgorithms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyUsageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.validTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customKeyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudHsmClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyManagerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerMasterKeySpecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAlgorithmsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAlgorithmsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyMetadata)) {
            return false;
        }
        KeyMetadata other = (KeyMetadata)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.keyUsageAsString(), other.keyUsageAsString()) && Objects.equals(this.keyStateAsString(), other.keyStateAsString()) && Objects.equals(this.deletionDate(), other.deletionDate()) && Objects.equals(this.validTo(), other.validTo()) && Objects.equals(this.originAsString(), other.originAsString()) && Objects.equals(this.customKeyStoreId(), other.customKeyStoreId()) && Objects.equals(this.cloudHsmClusterId(), other.cloudHsmClusterId()) && Objects.equals(this.expirationModelAsString(), other.expirationModelAsString()) && Objects.equals(this.keyManagerAsString(), other.keyManagerAsString()) && Objects.equals(this.customerMasterKeySpecAsString(), other.customerMasterKeySpecAsString()) && Objects.equals(this.encryptionAlgorithmsAsStrings(), other.encryptionAlgorithmsAsStrings()) && Objects.equals(this.signingAlgorithmsAsStrings(), other.signingAlgorithmsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"KeyMetadata").add("AWSAccountId", (Object)this.awsAccountId()).add("KeyId", (Object)this.keyId()).add("Arn", (Object)this.arn()).add("CreationDate", (Object)this.creationDate()).add("Enabled", (Object)this.enabled()).add("Description", (Object)this.description()).add("KeyUsage", (Object)this.keyUsageAsString()).add("KeyState", (Object)this.keyStateAsString()).add("DeletionDate", (Object)this.deletionDate()).add("ValidTo", (Object)this.validTo()).add("Origin", (Object)this.originAsString()).add("CustomKeyStoreId", (Object)this.customKeyStoreId()).add("CloudHsmClusterId", (Object)this.cloudHsmClusterId()).add("ExpirationModel", (Object)this.expirationModelAsString()).add("KeyManager", (Object)this.keyManagerAsString()).add("CustomerMasterKeySpec", (Object)this.customerMasterKeySpecAsString()).add("EncryptionAlgorithms", this.encryptionAlgorithmsAsStrings()).add("SigningAlgorithms", this.signingAlgorithmsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AWSAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "KeyUsage": {
                return Optional.ofNullable(clazz.cast(this.keyUsageAsString()));
            }
            case "KeyState": {
                return Optional.ofNullable(clazz.cast(this.keyStateAsString()));
            }
            case "DeletionDate": {
                return Optional.ofNullable(clazz.cast(this.deletionDate()));
            }
            case "ValidTo": {
                return Optional.ofNullable(clazz.cast(this.validTo()));
            }
            case "Origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
            case "CustomKeyStoreId": {
                return Optional.ofNullable(clazz.cast(this.customKeyStoreId()));
            }
            case "CloudHsmClusterId": {
                return Optional.ofNullable(clazz.cast(this.cloudHsmClusterId()));
            }
            case "ExpirationModel": {
                return Optional.ofNullable(clazz.cast(this.expirationModelAsString()));
            }
            case "KeyManager": {
                return Optional.ofNullable(clazz.cast(this.keyManagerAsString()));
            }
            case "CustomerMasterKeySpec": {
                return Optional.ofNullable(clazz.cast(this.customerMasterKeySpecAsString()));
            }
            case "EncryptionAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.encryptionAlgorithmsAsStrings()));
            }
            case "SigningAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.signingAlgorithmsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyMetadata, T> g) {
        return obj -> g.apply((KeyMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String keyId;
        private String arn;
        private Instant creationDate;
        private Boolean enabled;
        private String description;
        private String keyUsage;
        private String keyState;
        private Instant deletionDate;
        private Instant validTo;
        private String origin;
        private String customKeyStoreId;
        private String cloudHsmClusterId;
        private String expirationModel;
        private String keyManager;
        private String customerMasterKeySpec;
        private List<String> encryptionAlgorithms = DefaultSdkAutoConstructList.getInstance();
        private List<String> signingAlgorithms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KeyMetadata model) {
            this.awsAccountId(model.awsAccountId);
            this.keyId(model.keyId);
            this.arn(model.arn);
            this.creationDate(model.creationDate);
            this.enabled(model.enabled);
            this.description(model.description);
            this.keyUsage(model.keyUsage);
            this.keyState(model.keyState);
            this.deletionDate(model.deletionDate);
            this.validTo(model.validTo);
            this.origin(model.origin);
            this.customKeyStoreId(model.customKeyStoreId);
            this.cloudHsmClusterId(model.cloudHsmClusterId);
            this.expirationModel(model.expirationModel);
            this.keyManager(model.keyManager);
            this.customerMasterKeySpec(model.customerMasterKeySpec);
            this.encryptionAlgorithmsWithStrings(model.encryptionAlgorithms);
            this.signingAlgorithmsWithStrings(model.signingAlgorithms);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKeyUsage() {
            return this.keyUsage;
        }

        @Override
        public final Builder keyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        @Override
        public final Builder keyUsage(KeyUsageType keyUsage) {
            this.keyUsage(keyUsage == null ? null : keyUsage.toString());
            return this;
        }

        public final void setKeyUsage(String keyUsage) {
            this.keyUsage = keyUsage;
        }

        public final String getKeyState() {
            return this.keyState;
        }

        @Override
        public final Builder keyState(String keyState) {
            this.keyState = keyState;
            return this;
        }

        @Override
        public final Builder keyState(KeyState keyState) {
            this.keyState(keyState == null ? null : keyState.toString());
            return this;
        }

        public final void setKeyState(String keyState) {
            this.keyState = keyState;
        }

        public final Instant getDeletionDate() {
            return this.deletionDate;
        }

        @Override
        public final Builder deletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        public final void setDeletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
        }

        public final Instant getValidTo() {
            return this.validTo;
        }

        @Override
        public final Builder validTo(Instant validTo) {
            this.validTo = validTo;
            return this;
        }

        public final void setValidTo(Instant validTo) {
            this.validTo = validTo;
        }

        public final String getOrigin() {
            return this.origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(OriginType origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        public final String getCustomKeyStoreId() {
            return this.customKeyStoreId;
        }

        @Override
        public final Builder customKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
            return this;
        }

        public final void setCustomKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
        }

        public final String getCloudHsmClusterId() {
            return this.cloudHsmClusterId;
        }

        @Override
        public final Builder cloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
            return this;
        }

        public final void setCloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
        }

        public final String getExpirationModel() {
            return this.expirationModel;
        }

        @Override
        public final Builder expirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
            return this;
        }

        @Override
        public final Builder expirationModel(ExpirationModelType expirationModel) {
            this.expirationModel(expirationModel == null ? null : expirationModel.toString());
            return this;
        }

        public final void setExpirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
        }

        public final String getKeyManager() {
            return this.keyManager;
        }

        @Override
        public final Builder keyManager(String keyManager) {
            this.keyManager = keyManager;
            return this;
        }

        @Override
        public final Builder keyManager(KeyManagerType keyManager) {
            this.keyManager(keyManager == null ? null : keyManager.toString());
            return this;
        }

        public final void setKeyManager(String keyManager) {
            this.keyManager = keyManager;
        }

        public final String getCustomerMasterKeySpec() {
            return this.customerMasterKeySpec;
        }

        @Override
        public final Builder customerMasterKeySpec(String customerMasterKeySpec) {
            this.customerMasterKeySpec = customerMasterKeySpec;
            return this;
        }

        @Override
        public final Builder customerMasterKeySpec(CustomerMasterKeySpec customerMasterKeySpec) {
            this.customerMasterKeySpec(customerMasterKeySpec == null ? null : customerMasterKeySpec.toString());
            return this;
        }

        public final void setCustomerMasterKeySpec(String customerMasterKeySpec) {
            this.customerMasterKeySpec = customerMasterKeySpec;
        }

        public final Collection<String> getEncryptionAlgorithms() {
            return this.encryptionAlgorithms;
        }

        @Override
        public final Builder encryptionAlgorithmsWithStrings(Collection<String> encryptionAlgorithms) {
            this.encryptionAlgorithms = EncryptionAlgorithmSpecListCopier.copy(encryptionAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionAlgorithmsWithStrings(String ... encryptionAlgorithms) {
            this.encryptionAlgorithmsWithStrings(Arrays.asList(encryptionAlgorithms));
            return this;
        }

        @Override
        public final Builder encryptionAlgorithms(Collection<EncryptionAlgorithmSpec> encryptionAlgorithms) {
            this.encryptionAlgorithms = EncryptionAlgorithmSpecListCopier.copyEnumToString(encryptionAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionAlgorithms(EncryptionAlgorithmSpec ... encryptionAlgorithms) {
            this.encryptionAlgorithms(Arrays.asList(encryptionAlgorithms));
            return this;
        }

        public final void setEncryptionAlgorithms(Collection<String> encryptionAlgorithms) {
            this.encryptionAlgorithms = EncryptionAlgorithmSpecListCopier.copy(encryptionAlgorithms);
        }

        public final Collection<String> getSigningAlgorithms() {
            return this.signingAlgorithms;
        }

        @Override
        public final Builder signingAlgorithmsWithStrings(Collection<String> signingAlgorithms) {
            this.signingAlgorithms = SigningAlgorithmSpecListCopier.copy(signingAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signingAlgorithmsWithStrings(String ... signingAlgorithms) {
            this.signingAlgorithmsWithStrings(Arrays.asList(signingAlgorithms));
            return this;
        }

        @Override
        public final Builder signingAlgorithms(Collection<SigningAlgorithmSpec> signingAlgorithms) {
            this.signingAlgorithms = SigningAlgorithmSpecListCopier.copyEnumToString(signingAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signingAlgorithms(SigningAlgorithmSpec ... signingAlgorithms) {
            this.signingAlgorithms(Arrays.asList(signingAlgorithms));
            return this;
        }

        public final void setSigningAlgorithms(Collection<String> signingAlgorithms) {
            this.signingAlgorithms = SigningAlgorithmSpecListCopier.copy(signingAlgorithms);
        }

        public KeyMetadata build() {
            return new KeyMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyMetadata> {
        public Builder awsAccountId(String var1);

        public Builder keyId(String var1);

        public Builder arn(String var1);

        public Builder creationDate(Instant var1);

        public Builder enabled(Boolean var1);

        public Builder description(String var1);

        public Builder keyUsage(String var1);

        public Builder keyUsage(KeyUsageType var1);

        public Builder keyState(String var1);

        public Builder keyState(KeyState var1);

        public Builder deletionDate(Instant var1);

        public Builder validTo(Instant var1);

        public Builder origin(String var1);

        public Builder origin(OriginType var1);

        public Builder customKeyStoreId(String var1);

        public Builder cloudHsmClusterId(String var1);

        public Builder expirationModel(String var1);

        public Builder expirationModel(ExpirationModelType var1);

        public Builder keyManager(String var1);

        public Builder keyManager(KeyManagerType var1);

        public Builder customerMasterKeySpec(String var1);

        public Builder customerMasterKeySpec(CustomerMasterKeySpec var1);

        public Builder encryptionAlgorithmsWithStrings(Collection<String> var1);

        public Builder encryptionAlgorithmsWithStrings(String ... var1);

        public Builder encryptionAlgorithms(Collection<EncryptionAlgorithmSpec> var1);

        public Builder encryptionAlgorithms(EncryptionAlgorithmSpec ... var1);

        public Builder signingAlgorithmsWithStrings(Collection<String> var1);

        public Builder signingAlgorithmsWithStrings(String ... var1);

        public Builder signingAlgorithms(Collection<SigningAlgorithmSpec> var1);

        public Builder signingAlgorithms(SigningAlgorithmSpec ... var1);
    }
}

