/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.ExpirationModelType;
import software.amazon.awssdk.services.kms.model.KmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportKeyMaterialRequest
extends KmsRequest
implements ToCopyableBuilder<Builder, ImportKeyMaterialRequest> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportKeyMaterialRequest.getter(ImportKeyMaterialRequest::keyId)).setter(ImportKeyMaterialRequest.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<SdkBytes> IMPORT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(ImportKeyMaterialRequest.getter(ImportKeyMaterialRequest::importToken)).setter(ImportKeyMaterialRequest.setter(Builder::importToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportToken").build()}).build();
    private static final SdkField<SdkBytes> ENCRYPTED_KEY_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(ImportKeyMaterialRequest.getter(ImportKeyMaterialRequest::encryptedKeyMaterial)).setter(ImportKeyMaterialRequest.setter(Builder::encryptedKeyMaterial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedKeyMaterial").build()}).build();
    private static final SdkField<Instant> VALID_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ImportKeyMaterialRequest.getter(ImportKeyMaterialRequest::validTo)).setter(ImportKeyMaterialRequest.setter(Builder::validTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidTo").build()}).build();
    private static final SdkField<String> EXPIRATION_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportKeyMaterialRequest.getter(ImportKeyMaterialRequest::expirationModelAsString)).setter(ImportKeyMaterialRequest.setter(Builder::expirationModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationModel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, IMPORT_TOKEN_FIELD, ENCRYPTED_KEY_MATERIAL_FIELD, VALID_TO_FIELD, EXPIRATION_MODEL_FIELD));
    private final String keyId;
    private final SdkBytes importToken;
    private final SdkBytes encryptedKeyMaterial;
    private final Instant validTo;
    private final String expirationModel;

    private ImportKeyMaterialRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.importToken = builder.importToken;
        this.encryptedKeyMaterial = builder.encryptedKeyMaterial;
        this.validTo = builder.validTo;
        this.expirationModel = builder.expirationModel;
    }

    public String keyId() {
        return this.keyId;
    }

    public SdkBytes importToken() {
        return this.importToken;
    }

    public SdkBytes encryptedKeyMaterial() {
        return this.encryptedKeyMaterial;
    }

    public Instant validTo() {
        return this.validTo;
    }

    public ExpirationModelType expirationModel() {
        return ExpirationModelType.fromValue(this.expirationModel);
    }

    public String expirationModelAsString() {
        return this.expirationModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptedKeyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(this.validTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationModelAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyMaterialRequest)) {
            return false;
        }
        ImportKeyMaterialRequest other = (ImportKeyMaterialRequest)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.importToken(), other.importToken()) && Objects.equals(this.encryptedKeyMaterial(), other.encryptedKeyMaterial()) && Objects.equals(this.validTo(), other.validTo()) && Objects.equals(this.expirationModelAsString(), other.expirationModelAsString());
    }

    public String toString() {
        return ToString.builder((String)"ImportKeyMaterialRequest").add("KeyId", (Object)this.keyId()).add("ImportToken", (Object)this.importToken()).add("EncryptedKeyMaterial", (Object)this.encryptedKeyMaterial()).add("ValidTo", (Object)this.validTo()).add("ExpirationModel", (Object)this.expirationModelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "ImportToken": {
                return Optional.ofNullable(clazz.cast(this.importToken()));
            }
            case "EncryptedKeyMaterial": {
                return Optional.ofNullable(clazz.cast(this.encryptedKeyMaterial()));
            }
            case "ValidTo": {
                return Optional.ofNullable(clazz.cast(this.validTo()));
            }
            case "ExpirationModel": {
                return Optional.ofNullable(clazz.cast(this.expirationModelAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportKeyMaterialRequest, T> g) {
        return obj -> g.apply((ImportKeyMaterialRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsRequest.BuilderImpl
    implements Builder {
        private String keyId;
        private SdkBytes importToken;
        private SdkBytes encryptedKeyMaterial;
        private Instant validTo;
        private String expirationModel;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyMaterialRequest model) {
            super(model);
            this.keyId(model.keyId);
            this.importToken(model.importToken);
            this.encryptedKeyMaterial(model.encryptedKeyMaterial);
            this.validTo(model.validTo);
            this.expirationModel(model.expirationModel);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final ByteBuffer getImportToken() {
            return this.importToken == null ? null : this.importToken.asByteBuffer();
        }

        @Override
        public final Builder importToken(SdkBytes importToken) {
            this.importToken = StandardMemberCopier.copy((SdkBytes)importToken);
            return this;
        }

        public final void setImportToken(ByteBuffer importToken) {
            this.importToken(importToken == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)importToken));
        }

        public final ByteBuffer getEncryptedKeyMaterial() {
            return this.encryptedKeyMaterial == null ? null : this.encryptedKeyMaterial.asByteBuffer();
        }

        @Override
        public final Builder encryptedKeyMaterial(SdkBytes encryptedKeyMaterial) {
            this.encryptedKeyMaterial = StandardMemberCopier.copy((SdkBytes)encryptedKeyMaterial);
            return this;
        }

        public final void setEncryptedKeyMaterial(ByteBuffer encryptedKeyMaterial) {
            this.encryptedKeyMaterial(encryptedKeyMaterial == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)encryptedKeyMaterial));
        }

        public final Instant getValidTo() {
            return this.validTo;
        }

        @Override
        public final Builder validTo(Instant validTo) {
            this.validTo = validTo;
            return this;
        }

        public final void setValidTo(Instant validTo) {
            this.validTo = validTo;
        }

        public final String getExpirationModel() {
            return this.expirationModel;
        }

        @Override
        public final Builder expirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
            return this;
        }

        @Override
        public final Builder expirationModel(ExpirationModelType expirationModel) {
            this.expirationModel(expirationModel == null ? null : expirationModel.toString());
            return this;
        }

        public final void setExpirationModel(String expirationModel) {
            this.expirationModel = expirationModel;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportKeyMaterialRequest build() {
            return new ImportKeyMaterialRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportKeyMaterialRequest> {
        public Builder keyId(String var1);

        public Builder importToken(SdkBytes var1);

        public Builder encryptedKeyMaterial(SdkBytes var1);

        public Builder validTo(Instant var1);

        public Builder expirationModel(String var1);

        public Builder expirationModel(ExpirationModelType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

