/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum KeyUsageType {
    ENCRYPT_DECRYPT("ENCRYPT_DECRYPT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private KeyUsageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyUsageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(KeyUsageType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyUsageType> knownValues() {
        return Stream.of(KeyUsageType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

