/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ScheduleKeyDeletionRequestModelMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").isBinary(false).build();
    private static final MarshallingInfo<Integer> PENDINGWINDOWINDAYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PendingWindowInDays").isBinary(false).build();
    private static final ScheduleKeyDeletionRequestModelMarshaller INSTANCE = new ScheduleKeyDeletionRequestModelMarshaller();

    private ScheduleKeyDeletionRequestModelMarshaller() {
    }

    public static ScheduleKeyDeletionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ScheduleKeyDeletionRequest scheduleKeyDeletionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)scheduleKeyDeletionRequest), (String)"scheduleKeyDeletionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)scheduleKeyDeletionRequest.keyId(), KEYID_BINDING);
            protocolMarshaller.marshall((Object)scheduleKeyDeletionRequest.pendingWindowInDays(), PENDINGWINDOWINDAYS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

