/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.RetireGrantRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RetireGrantRequestModelMarshaller {
    private static final MarshallingInfo<String> GRANTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrantToken").isBinary(false).build();
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").isBinary(false).build();
    private static final MarshallingInfo<String> GRANTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrantId").isBinary(false).build();
    private static final RetireGrantRequestModelMarshaller INSTANCE = new RetireGrantRequestModelMarshaller();

    private RetireGrantRequestModelMarshaller() {
    }

    public static RetireGrantRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RetireGrantRequest retireGrantRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)retireGrantRequest), (String)"retireGrantRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)retireGrantRequest.grantToken(), GRANTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)retireGrantRequest.keyId(), KEYID_BINDING);
            protocolMarshaller.marshall((Object)retireGrantRequest.grantId(), GRANTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

