/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kms.model.KeyListEntry;

public class KeyListEntryUnmarshaller
implements Unmarshaller<KeyListEntry, JsonUnmarshallerContext> {
    private static final KeyListEntryUnmarshaller INSTANCE = new KeyListEntryUnmarshaller();

    public KeyListEntry unmarshall(JsonUnmarshallerContext context) throws Exception {
        KeyListEntry.Builder keyListEntryBuilder = KeyListEntry.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("KeyId", targetDepth)) {
                    context.nextToken();
                    keyListEntryBuilder.keyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KeyArn", targetDepth)) {
                    context.nextToken();
                    keyListEntryBuilder.keyArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (KeyListEntry)keyListEntryBuilder.build();
    }

    public static KeyListEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

