/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.kms.KMSClient;
import software.amazon.awssdk.services.kms.model.KeyListEntry;
import software.amazon.awssdk.services.kms.model.ListKeysRequest;
import software.amazon.awssdk.services.kms.model.ListKeysResponse;

public final class ListKeysPaginator
implements SdkIterable<ListKeysResponse> {
    private final KMSClient client;
    private final ListKeysRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListKeysPaginator(KMSClient client, ListKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListKeysResponseFetcher();
    }

    public Iterator<ListKeysResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<KeyListEntry> keys() {
        Function<ListKeysResponse, Iterator> getIterator = response -> response != null ? response.keys().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListKeysResponseFetcher
    implements NextPageFetcher<ListKeysResponse> {
        private ListKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListKeysResponse previousPage) {
            return previousPage.truncated();
        }

        public ListKeysResponse nextPage(ListKeysResponse previousPage) {
            if (previousPage == null) {
                return ListKeysPaginator.this.client.listKeys(ListKeysPaginator.this.firstRequest);
            }
            return ListKeysPaginator.this.client.listKeys((ListKeysRequest)((Object)ListKeysPaginator.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

