/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.kms.model.DataKeySpec;
import software.amazon.awssdk.services.kms.model.EncryptionContextTypeCopier;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.services.kms.model.KMSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GenerateDataKeyWithoutPlaintextRequest
extends KMSRequest
implements ToCopyableBuilder<Builder, GenerateDataKeyWithoutPlaintextRequest> {
    private final String keyId;
    private final Map<String, String> encryptionContext;
    private final String keySpec;
    private final Integer numberOfBytes;
    private final List<String> grantTokens;

    private GenerateDataKeyWithoutPlaintextRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.encryptionContext = builder.encryptionContext;
        this.keySpec = builder.keySpec;
        this.numberOfBytes = builder.numberOfBytes;
        this.grantTokens = builder.grantTokens;
    }

    public String keyId() {
        return this.keyId;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public DataKeySpec keySpec() {
        return DataKeySpec.fromValue(this.keySpec);
    }

    public String keySpecString() {
        return this.keySpec;
    }

    public Integer numberOfBytes() {
        return this.numberOfBytes;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.keySpecString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantTokens());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateDataKeyWithoutPlaintextRequest)) {
            return false;
        }
        GenerateDataKeyWithoutPlaintextRequest other = (GenerateDataKeyWithoutPlaintextRequest)((Object)obj);
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.encryptionContext(), other.encryptionContext()) && Objects.equals(this.keySpecString(), other.keySpecString()) && Objects.equals(this.numberOfBytes(), other.numberOfBytes()) && Objects.equals(this.grantTokens(), other.grantTokens());
    }

    public String toString() {
        return ToString.builder((String)"GenerateDataKeyWithoutPlaintextRequest").add("KeyId", (Object)this.keyId()).add("EncryptionContext", this.encryptionContext()).add("KeySpec", (Object)this.keySpecString()).add("NumberOfBytes", (Object)this.numberOfBytes()).add("GrantTokens", this.grantTokens()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
            case "EncryptionContext": {
                return Optional.of(clazz.cast(this.encryptionContext()));
            }
            case "KeySpec": {
                return Optional.of(clazz.cast(this.keySpecString()));
            }
            case "NumberOfBytes": {
                return Optional.of(clazz.cast(this.numberOfBytes()));
            }
            case "GrantTokens": {
                return Optional.of(clazz.cast(this.grantTokens()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KMSRequest.BuilderImpl
    implements Builder {
        private String keyId;
        private Map<String, String> encryptionContext;
        private String keySpec;
        private Integer numberOfBytes;
        private List<String> grantTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateDataKeyWithoutPlaintextRequest model) {
            this.keyId(model.keyId);
            this.encryptionContext(model.encryptionContext);
            this.keySpec(model.keySpec);
            this.numberOfBytes(model.numberOfBytes);
            this.grantTokens(model.grantTokens);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Map<String, String> getEncryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public final Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
            return this;
        }

        public final void setEncryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
        }

        public final String getKeySpec() {
            return this.keySpec;
        }

        @Override
        public final Builder keySpec(String keySpec) {
            this.keySpec = keySpec;
            return this;
        }

        @Override
        public final Builder keySpec(DataKeySpec keySpec) {
            this.keySpec(keySpec.toString());
            return this;
        }

        public final void setKeySpec(String keySpec) {
            this.keySpec = keySpec;
        }

        public final Integer getNumberOfBytes() {
            return this.numberOfBytes;
        }

        @Override
        public final Builder numberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
            return this;
        }

        public final void setNumberOfBytes(Integer numberOfBytes) {
            this.numberOfBytes = numberOfBytes;
        }

        public final Collection<String> getGrantTokens() {
            return this.grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GenerateDataKeyWithoutPlaintextRequest build() {
            return new GenerateDataKeyWithoutPlaintextRequest(this);
        }
    }

    public static interface Builder
    extends KMSRequest.Builder,
    CopyableBuilder<Builder, GenerateDataKeyWithoutPlaintextRequest> {
        public Builder keyId(String var1);

        public Builder encryptionContext(Map<String, String> var1);

        public Builder keySpec(String var1);

        public Builder keySpec(DataKeySpec var1);

        public Builder numberOfBytes(Integer var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

