/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.kms.model.EncryptionContextTypeCopier;
import software.amazon.awssdk.services.kms.model.GrantTokenListCopier;
import software.amazon.awssdk.services.kms.model.KMSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DecryptRequest
extends KMSRequest
implements ToCopyableBuilder<Builder, DecryptRequest> {
    private final ByteBuffer ciphertextBlob;
    private final Map<String, String> encryptionContext;
    private final List<String> grantTokens;

    private DecryptRequest(BuilderImpl builder) {
        super(builder);
        this.ciphertextBlob = builder.ciphertextBlob;
        this.encryptionContext = builder.encryptionContext;
        this.grantTokens = builder.grantTokens;
    }

    public ByteBuffer ciphertextBlob() {
        return this.ciphertextBlob == null ? null : this.ciphertextBlob.asReadOnlyBuffer();
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ciphertextBlob());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantTokens());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecryptRequest)) {
            return false;
        }
        DecryptRequest other = (DecryptRequest)((Object)obj);
        return Objects.equals(this.ciphertextBlob(), other.ciphertextBlob()) && Objects.equals(this.encryptionContext(), other.encryptionContext()) && Objects.equals(this.grantTokens(), other.grantTokens());
    }

    public String toString() {
        return ToString.builder((String)"DecryptRequest").add("CiphertextBlob", (Object)this.ciphertextBlob()).add("EncryptionContext", this.encryptionContext()).add("GrantTokens", this.grantTokens()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CiphertextBlob": {
                return Optional.of(clazz.cast(this.ciphertextBlob()));
            }
            case "EncryptionContext": {
                return Optional.of(clazz.cast(this.encryptionContext()));
            }
            case "GrantTokens": {
                return Optional.of(clazz.cast(this.grantTokens()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends KMSRequest.BuilderImpl
    implements Builder {
        private ByteBuffer ciphertextBlob;
        private Map<String, String> encryptionContext;
        private List<String> grantTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(DecryptRequest model) {
            this.ciphertextBlob(model.ciphertextBlob);
            this.encryptionContext(model.encryptionContext);
            this.grantTokens(model.grantTokens);
        }

        public final ByteBuffer getCiphertextBlob() {
            return this.ciphertextBlob;
        }

        @Override
        public final Builder ciphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy((ByteBuffer)ciphertextBlob);
            return this;
        }

        public final void setCiphertextBlob(ByteBuffer ciphertextBlob) {
            this.ciphertextBlob = StandardMemberCopier.copy((ByteBuffer)ciphertextBlob);
        }

        public final Map<String, String> getEncryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public final Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
            return this;
        }

        public final void setEncryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = EncryptionContextTypeCopier.copy(encryptionContext);
        }

        public final Collection<String> getGrantTokens() {
            return this.grantTokens;
        }

        @Override
        public final Builder grantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantTokens(String ... grantTokens) {
            this.grantTokens(Arrays.asList(grantTokens));
            return this;
        }

        public final void setGrantTokens(Collection<String> grantTokens) {
            this.grantTokens = GrantTokenListCopier.copy(grantTokens);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DecryptRequest build() {
            return new DecryptRequest(this);
        }
    }

    public static interface Builder
    extends KMSRequest.Builder,
    CopyableBuilder<Builder, DecryptRequest> {
        public Builder ciphertextBlob(ByteBuffer var1);

        public Builder encryptionContext(Map<String, String> var1);

        public Builder grantTokens(Collection<String> var1);

        public Builder grantTokens(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

