/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kms.model.CreateKeyRequest;

@SdkInternalApi
public class CreateKeyRequestModelMarshaller {
    private static final MarshallingInfo<String> POLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Policy").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> KEYUSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyUsage").build();
    private static final MarshallingInfo<String> ORIGIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Origin").build();
    private static final MarshallingInfo<Boolean> BYPASSPOLICYLOCKOUTSAFETYCHECK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BypassPolicyLockoutSafetyCheck").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final CreateKeyRequestModelMarshaller INSTANCE = new CreateKeyRequestModelMarshaller();

    public static CreateKeyRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateKeyRequest createKeyRequest, ProtocolMarshaller protocolMarshaller) {
        if (createKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createKeyRequest.policy(), POLICY_BINDING);
            protocolMarshaller.marshall((Object)createKeyRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createKeyRequest.keyUsageString(), KEYUSAGE_BINDING);
            protocolMarshaller.marshall((Object)createKeyRequest.originString(), ORIGIN_BINDING);
            protocolMarshaller.marshall((Object)createKeyRequest.bypassPolicyLockoutSafetyCheck(), BYPASSPOLICYLOCKOUTSAFETYCHECK_BINDING);
            protocolMarshaller.marshall(createKeyRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

